/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.Debugger;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.panels.ImgPacksPanelAutomationHelper;
import com.izforge.izpack.panels.PacksModel;
import com.izforge.izpack.panels.PacksPanelBase;
import com.izforge.izpack.panels.PacksPanelInterface;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.n3.nanoxml.XMLElement;

public abstract class PacksPanelBase
extends IzPanel
implements PacksPanelInterface,
ListSelectionListener {
    protected JLabel freeSpaceLabel;
    protected JLabel spaceLabel;
    protected JTextArea descriptionArea;
    protected JTextArea dependencyArea;
    protected JTable packsTable;
    protected PacksModel packsModel;
    protected JScrollPane tableScroller;
    private Map<String, Pack> names;
    protected long bytes = 0L;
    protected long freeBytes = 0L;
    protected boolean dependenciesExist = false;
    private LocaleDatabase langpack = null;
    private static final String LANG_FILE_NAME = "packsLang.xml";
    private Debugger debugger;

    public PacksPanelBase(InstallerFrame parent, InstallData idata) {
        super(parent, idata);
        try {
            this.langpack = parent.langpack;
            InputStream inputStream = ResourceManager.getInstance().getInputStream(LANG_FILE_NAME);
            this.langpack.add(inputStream);
            this.debugger = parent.getDebugger();
        }
        catch (Throwable exception) {
            Debug.trace((Object)exception);
        }
        this.computePacks(idata.availablePacks);
        this.createNormalLayout();
    }

    protected abstract void createNormalLayout();

    public LocaleDatabase getLangpack() {
        return this.langpack;
    }

    public long getBytes() {
        return this.bytes;
    }

    public void setBytes(long bytes) {
        this.bytes = bytes;
    }

    public void showSpaceRequired() {
        if (this.spaceLabel != null) {
            this.spaceLabel.setText(Pack.toByteUnitsString((long)this.bytes));
        }
    }

    public void showFreeSpace() {
        if (IoHelper.supported((String)"getFreeSpace") && this.freeSpaceLabel != null) {
            this.freeBytes = IoHelper.getFreeSpace((String)IoHelper.existingParent((File)new File(this.idata.getInstallPath())).getAbsolutePath());
            String msg = this.freeBytes < 0L ? this.parent.langpack.getString("PacksPanel.notAscertainable") : Pack.toByteUnitsString((long)this.freeBytes);
            this.freeSpaceLabel.setText(msg);
        }
    }

    public boolean isValidated() {
        if (IoHelper.supported((String)"getFreeSpace") && this.freeBytes >= 0L && this.freeBytes <= this.bytes) {
            JOptionPane.showMessageDialog((Component)this, this.parent.langpack.getString("PacksPanel.notEnoughSpace"), this.parent.langpack.getString("installer.error"), 0);
            return false;
        }
        return true;
    }

    public void makeXMLData(XMLElement panelRoot) {
        new ImgPacksPanelAutomationHelper().makeXMLData((AutomatedInstallData)this.idata, panelRoot);
    }

    public void valueChanged(ListSelectionEvent e) {
        Pack pack;
        int selectedRow = this.packsTable.getSelectedRow();
        if (this.descriptionArea != null && selectedRow != -1) {
            pack = (Pack)this.idata.availablePacks.get(selectedRow);
            String desc = "";
            String key = pack.id + ".description";
            if (this.langpack != null && pack.id != null && !"".equals(pack.id)) {
                desc = this.langpack.getString(key);
            }
            if ("".equals(desc) || key.equals(desc)) {
                desc = pack.description;
            }
            VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
            desc = vs.substitute(desc, null);
            this.descriptionArea.setText(desc);
        }
        if (this.dependencyArea != null && selectedRow != -1) {
            pack = (Pack)this.idata.availablePacks.get(selectedRow);
            List dep = pack.dependencies;
            String list = "";
            if (dep != null) {
                list = list + (this.langpack == null ? "Dependencies: " : this.langpack.getString("PacksPanel.dependencies"));
            }
            for (int j = 0; dep != null && j < dep.size(); ++j) {
                String name = (String)dep.get(j);
                list = list + this.getI18NPackName((Pack)this.names.get(name));
                if (j == dep.size() - 1) continue;
                list = list + ", ";
            }
            String excludeslist = this.langpack == null ? "Excludes: " : this.langpack.getString("PacksPanel.excludes");
            int numexcludes = 0;
            if (pack.excludeGroup != null) {
                for (int q = 0; q < this.idata.availablePacks.size(); ++q) {
                    Pack otherpack = (Pack)this.idata.availablePacks.get(q);
                    String exgroup = otherpack.excludeGroup;
                    if (exgroup == null || q == selectedRow || !pack.excludeGroup.equals(exgroup)) continue;
                    excludeslist = excludeslist + this.getI18NPackName(otherpack) + ", ";
                    ++numexcludes;
                }
            }
            if (dep != null) {
                excludeslist = "    " + excludeslist;
            }
            if (numexcludes > 0) {
                list = list + excludeslist;
            }
            if (list.endsWith(", ")) {
                list = list.substring(0, list.length() - 2);
            }
            this.dependencyArea.setText(list);
        }
    }

    private String getI18NPackName(Pack pack) {
        String packName = pack.name;
        String key = pack.id;
        if (this.langpack != null && pack.id != null && !"".equals(pack.id)) {
            packName = this.langpack.getString(key);
        }
        if ("".equals(packName) || key == null || key.equals(packName)) {
            packName = pack.name;
        }
        return packName;
    }

    protected JLabel createLabel(String msgId, String iconId, GridBagLayout layout, GridBagConstraints constraints) {
        JLabel label = LabelFactory.create((String)this.parent.langpack.getString(msgId), (Icon)this.parent.icons.getImageIcon(iconId), (int)11);
        if (layout != null && constraints != null) {
            layout.addLayoutComponent(label, constraints);
        }
        this.add((Component)label);
        return label;
    }

    protected JLabel createPanelWithLabel(String msgId, GridBagLayout layout, GridBagConstraints constraints) {
        JPanel panel = new JPanel();
        JLabel label = new JLabel();
        panel.setAlignmentX(0.0f);
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(LabelFactory.create((String)this.parent.langpack.getString(msgId)));
        panel.add(Box.createHorizontalGlue());
        panel.add(label);
        if (layout != null && constraints != null) {
            layout.addLayoutComponent(panel, constraints);
        }
        this.add((Component)panel);
        return label;
    }

    protected JTextArea createTextArea(String msgId, JScrollPane scroller, GridBagLayout layout, GridBagConstraints constraints) {
        JTextArea area = new JTextArea();
        area.setAlignmentX(0.0f);
        area.setCaretPosition(0);
        area.setEditable(false);
        area.setEditable(false);
        area.setOpaque(false);
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        area.setBorder(BorderFactory.createTitledBorder(this.parent.langpack.getString(msgId)));
        area.setFont(this.getControlTextFont());
        if (layout != null && constraints != null) {
            if (scroller != null) {
                layout.addLayoutComponent(scroller, constraints);
            } else {
                layout.addLayoutComponent(area, constraints);
            }
        }
        if (scroller != null) {
            scroller.setViewportView(area);
            this.add((Component)scroller);
        } else {
            this.add((Component)area);
        }
        return area;
    }

    protected JTable createPacksTable(int width, JScrollPane scroller, GridBagLayout layout, GridBagConstraints constraints) {
        JTable table = new JTable();
        table.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        table.setIntercellSpacing(new Dimension(0, 0));
        table.setBackground(Color.white);
        table.setSelectionMode(0);
        table.getSelectionModel().addListSelectionListener((ListSelectionListener)this);
        table.setShowGrid(false);
        scroller.setViewportView(table);
        scroller.setAlignmentX(0.0f);
        scroller.getViewport().setBackground(Color.white);
        scroller.setPreferredSize(new Dimension(width, this.idata.guiPrefs.height / 3 + 30));
        if (layout != null && constraints != null) {
            layout.addLayoutComponent(scroller, constraints);
        }
        this.add((Component)scroller);
        return table;
    }

    private void computePacks(List packs) {
        this.names = new HashMap();
        this.dependenciesExist = false;
        for (Object pack1 : packs) {
            Pack pack = (Pack)pack1;
            this.names.put(pack.name, pack);
            if (pack.dependencies == null && pack.excludeGroup == null) continue;
            this.dependenciesExist = true;
        }
    }

    public void panelActivate() {
        try {
            this.packsModel = new /* Unavailable Anonymous Inner Class!! */;
            this.packsTable.setModel((TableModel)this.packsModel);
            CheckBoxRenderer packSelectedRenderer = new CheckBoxRenderer();
            this.packsTable.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)packSelectedRenderer);
            this.packsTable.getColumnModel().getColumn(0).setMaxWidth(40);
            this.packsTable.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)new PacksPanelTableCellRenderer());
            PacksPanelTableCellRenderer packTextColumnRenderer = new PacksPanelTableCellRenderer();
            packTextColumnRenderer.setHorizontalAlignment(4);
            this.packsTable.getColumnModel().getColumn(2).setCellRenderer((TableCellRenderer)packTextColumnRenderer);
            this.packsTable.getColumnModel().getColumn(2).setMaxWidth(100);
            this.packsTable.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
            this.tableScroller.remove(this.packsTable.getTableHeader());
            this.tableScroller.setColumnHeaderView(null);
            this.tableScroller.setColumnHeader(null);
            Iterator iter = this.idata.availablePacks.iterator();
            this.bytes = 0L;
            while (iter.hasNext()) {
                Pack p = (Pack)iter.next();
                if (p.required) {
                    this.bytes += p.nbytes;
                    continue;
                }
                if (!this.idata.selectedPacks.contains(p)) continue;
                this.bytes += p.nbytes;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.showSpaceRequired();
        this.showFreeSpace();
        this.packsTable.setRowSelectionInterval(0, 0);
    }

    public String getSummaryBody() {
        StringBuffer retval = new StringBuffer(256);
        Iterator<Object> iter = this.idata.selectedPacks.iterator();
        boolean first = true;
        while (iter.hasNext()) {
            if (!first) {
                retval.append("<br>");
            }
            first = false;
            Pack pack = (Pack)iter.next();
            if (this.langpack != null && pack.id != null && !"".equals(pack.id)) {
                retval.append(this.langpack.getString(pack.id));
                continue;
            }
            retval.append(pack.name);
        }
        if (this.packsModel.isModifyinstallation()) {
            Map installedpacks = this.packsModel.getInstalledpacks();
            iter = installedpacks.keySet().iterator();
            retval.append("<br><b>");
            retval.append(this.langpack.getString("PacksPanel.installedpacks.summarycaption"));
            retval.append("</b>");
            retval.append("<br>");
            while (iter.hasNext()) {
                Pack pack = (Pack)installedpacks.get(iter.next());
                if (this.langpack != null && pack.id != null && !"".equals(pack.id)) {
                    retval.append(this.langpack.getString(pack.id));
                } else {
                    retval.append(pack.name);
                }
                retval.append("<br>");
            }
        }
        return retval.toString();
    }

    public Debugger getDebugger() {
        return this.debugger;
    }
}

