/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Processor;
import com.izforge.izpack.panels.Validator;
import com.izforge.izpack.panels.ValidatorContainer;
import com.izforge.izpack.util.Debug;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JPasswordField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordGroup
implements ProcessingClient {
    private Vector<JPasswordField> fields = new Vector();
    private List<ValidatorContainer> validatorContainers = null;
    private Processor processor = null;
    private String modifiedPassword = null;
    private int currentValidator = 0;
    private InstallData idata;

    public PasswordGroup(InstallData idata, List<ValidatorContainer> validatorContainers, String processor) {
        try {
            this.idata = idata;
            this.validatorContainers = validatorContainers;
        }
        catch (Throwable exception) {
            Debug.trace((Object)("Failed in PasswordGroup constructor: " + exception));
            this.validatorContainers = null;
        }
        try {
            this.processor = (Processor)Class.forName(processor).newInstance();
        }
        catch (Throwable exception) {
            Debug.trace((Object)("Failed in PasswordGroup constructor making processor: " + exception));
            this.processor = null;
        }
    }

    public InstallData getIdata() {
        return this.idata;
    }

    public int getNumFields() {
        return this.fields.size();
    }

    public String getFieldContents(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.fields.size()) {
            throw new IndexOutOfBoundsException();
        }
        String contents = new String(((JPasswordField)this.fields.elementAt(index)).getPassword());
        return contents;
    }

    public void addField(JPasswordField field) {
        if (field != null) {
            this.fields.add(field);
        }
    }

    public boolean validateContents(int i) {
        boolean returnValue = true;
        try {
            this.currentValidator = i;
            ValidatorContainer container = this.getValidatorContainer(i);
            Validator validator = container.getValidator();
            if (validator != null) {
                returnValue = validator.validate((ProcessingClient)this);
            }
        }
        catch (Exception e) {
            Debug.trace((Object)("validateContents(" + i + ") failed: " + e));
        }
        return returnValue;
    }

    public String getValidatorMessage(int i) {
        String returnValue = null;
        try {
            ValidatorContainer container = this.getValidatorContainer(i);
            if (container != null) {
                returnValue = container.getMessage();
            }
        }
        catch (Exception e) {
            Debug.trace((Object)("getValidatorMessage(" + i + ") failed: " + e));
        }
        return returnValue;
    }

    public int validatorSize() {
        int size = 0;
        if (this.validatorContainers != null) {
            size = this.validatorContainers.size();
        }
        return size;
    }

    public ValidatorContainer getValidatorContainer() {
        return this.getValidatorContainer(this.currentValidator);
    }

    public ValidatorContainer getValidatorContainer(int i) {
        ValidatorContainer container = null;
        try {
            container = (ValidatorContainer)this.validatorContainers.get(i);
        }
        catch (Exception e) {
            container = null;
        }
        return container;
    }

    public boolean hasParams() {
        return this.hasParams(this.currentValidator);
    }

    public boolean hasParams(int i) {
        boolean returnValue = false;
        try {
            ValidatorContainer container = this.getValidatorContainer(i);
            if (container != null) {
                returnValue = container.hasParams();
            }
        }
        catch (Exception e) {
            Debug.trace((Object)("hasParams(" + i + ") failed: " + e));
        }
        return returnValue;
    }

    public Map<String, String> getValidatorParams() {
        return this.getValidatorParams(this.currentValidator);
    }

    public Map<String, String> getValidatorParams(int i) {
        Map returnValue = null;
        try {
            ValidatorContainer container = this.getValidatorContainer(i);
            if (container != null) {
                returnValue = container.getValidatorParams();
            }
        }
        catch (Exception e) {
            Debug.trace((Object)("getValidatorParams(" + i + ") failed: " + e));
        }
        return returnValue;
    }

    public String getText() {
        return this.getValidatorMessage(this.currentValidator);
    }

    public void setModifiedPassword(String value) {
        this.modifiedPassword = value;
    }

    public String getPassword() {
        String returnValue = "";
        if (this.modifiedPassword != null) {
            returnValue = this.modifiedPassword;
            if (this.processor != null) {
                Debug.trace((Object)"Validator changed password, PROCESSOR WILL NOT RUN!");
            }
        } else if (this.processor != null) {
            returnValue = this.processor.process((ProcessingClient)this);
        } else if (this.fields.size() > 0) {
            returnValue = new String(((JPasswordField)this.fields.elementAt(0)).getPassword());
        }
        return returnValue;
    }
}

