/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelAutomation;
import com.izforge.izpack.util.Debug;
import java.util.Map;
import java.util.Vector;
import net.n3.nanoxml.XMLElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserInputPanelAutomationHelper
implements PanelAutomation {
    private static final String AUTO_KEY_USER_INPUT = "userInput";
    private static final String AUTO_KEY_ENTRY = "entry";
    private static final String AUTO_ATTRIBUTE_KEY = "key";
    private static final String AUTO_ATTRIBUTE_VALUE = "value";
    private Map<String, String> entries;

    public UserInputPanelAutomationHelper() {
        this.entries = null;
    }

    public UserInputPanelAutomationHelper(Map<String, String> entries) {
        this.entries = entries;
    }

    public void makeXMLData(AutomatedInstallData idata, XMLElement panelRoot) {
        XMLElement userInput = new XMLElement(AUTO_KEY_USER_INPUT);
        panelRoot.addChild(userInput);
        for (String key : this.entries.keySet()) {
            String value = (String)this.entries.get(key);
            XMLElement dataElement = new XMLElement(AUTO_KEY_ENTRY);
            dataElement.setAttribute(AUTO_ATTRIBUTE_KEY, key);
            dataElement.setAttribute(AUTO_ATTRIBUTE_VALUE, value);
            userInput.addChild(dataElement);
        }
    }

    public boolean runAutomated(AutomatedInstallData idata, XMLElement panelRoot) {
        XMLElement userInput = panelRoot.getFirstChildNamed(AUTO_KEY_USER_INPUT);
        if (userInput == null) {
            return false;
        }
        Vector userEntries = userInput.getChildrenNamed(AUTO_KEY_ENTRY);
        if (userEntries == null) {
            return false;
        }
        for (int i = 0; i < userEntries.size(); ++i) {
            XMLElement dataElement = (XMLElement)userEntries.elementAt(i);
            String variable = dataElement.getAttribute(AUTO_ATTRIBUTE_KEY);
            String value = dataElement.getAttribute(AUTO_ATTRIBUTE_VALUE);
            Debug.trace((Object)("UserInputPanel: setting variable " + variable + " to " + value));
            idata.setVariable(variable, value);
        }
        return true;
    }
}

