/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class XInfoPanel
extends IzPanel {
    private static final long serialVersionUID = 3257009856274970416L;
    private JTextArea textArea;
    private String info;

    public XInfoPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints gbConstraints = new GridBagConstraints();
        this.setLayout((LayoutManager)layout);
        JLabel infoLabel = LabelFactory.create((String)parent.langpack.getString("InfoPanel.info"), (Icon)parent.icons.getImageIcon("edit"), (int)11);
        parent.buildConstraints(gbConstraints, 0, 0, 1, 1, 1.0, 0.0);
        gbConstraints.insets = new Insets(5, 5, 5, 5);
        gbConstraints.fill = 1;
        gbConstraints.anchor = 16;
        layout.addLayoutComponent(infoLabel, gbConstraints);
        this.add((Component)infoLabel);
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        JScrollPane scroller = new JScrollPane(this.textArea);
        parent.buildConstraints(gbConstraints, 0, 1, 1, 1, 1.0, 0.9);
        gbConstraints.anchor = 10;
        layout.addLayoutComponent(scroller, gbConstraints);
        this.add((Component)scroller);
    }

    private void loadInfo() {
        try {
            this.info = ResourceManager.getInstance().getTextResource("XInfoPanel.info");
        }
        catch (Exception err) {
            this.info = "Error : could not load the info text !";
        }
    }

    private void parseText() {
        try {
            VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
            this.info = vs.substitute(this.info, null);
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public void panelActivate() {
        this.loadInfo();
        this.parseText();
        this.textArea.setText(this.info);
        this.textArea.setCaretPosition(0);
    }

    public boolean isValidated() {
        return true;
    }
}

