/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.system.plugin.izpack.util;

import java.io.File;
import java.io.FileFilter;

import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.SelectorUtils;

public class FileFilterImpl implements FileFilter {

    private String[] excludes = DirectoryScanner.DEFAULTEXCLUDES;

    public FileFilterImpl() {
        for (int i = 0; i < excludes.length; i++) {
            excludes[i] = excludes[i].replace('/', File.separatorChar).replace('\\', File.separatorChar);
        }
    }

    public boolean accept(File file) {
        for (int i = 0; i < excludes.length; i++) {
            if (SelectorUtils.matchPath(excludes[i], file.getName(), true)) {
                return false;
            }
        }
        return true;
    }

}
