/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.eoa.system.plugin.izpack;

import com.izforge.izpack.compiler.CompilerConfig;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.path.DefaultPathTranslator;
import org.bluestemsoftware.open.eoa.system.plugin.izpack.CustomAction;
import org.bluestemsoftware.open.eoa.system.plugin.izpack.InstallationJar;
import org.bluestemsoftware.open.eoa.system.plugin.izpack.Panel;
import org.bluestemsoftware.open.eoa.system.plugin.izpack.Resource;
import org.bluestemsoftware.open.eoa.system.plugin.izpack.util.FileUtils;
import org.bluestemsoftware.open.eoa.system.plugin.izpack.util.InterpolationHelper;

public class IzPackMojo
extends AbstractMojo {
    private MavenProject project;
    private String workDirectory;
    private String outputDirectory;
    private String finalName;
    private List<DefaultArtifact> pluginArtifacts;
    private MavenProjectHelper projectHelper;
    private String installationType;
    private String installationFile;
    private List<Panel> panels = new ArrayList<Panel>();
    private List<CustomAction> customActions = new ArrayList<CustomAction>();
    private List<Resource> resources = new ArrayList<Resource>();
    private List<InstallationJar> installationJars = new ArrayList<InstallationJar>();
    private String packFileExtensionType;

    public void execute() throws MojoExecutionException {
        File[] list;
        String classifier;
        File targetFile;
        String versionlessKey;
        String name;
        this.getLog().info((CharSequence)" ======= IzPackMojo settings =======");
        this.getLog().info((CharSequence)("workDirectory[" + this.workDirectory + "]"));
        this.getLog().info((CharSequence)("outputDirectory[" + this.outputDirectory + "]"));
        this.getLog().info((CharSequence)("installationFile[" + this.installationFile + "]"));
        String input = null;
        try {
            input = this.interpolateFile(this.installationFile, this.project.getModel()).getAbsolutePath();
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error replacing maven vars. " + ex);
        }
        File izpackDistro = null;
        for (DefaultArtifact defaultArtifact : this.pluginArtifacts) {
            String artifactID = defaultArtifact.getArtifactId();
            if (!artifactID.equals("izpack-distro")) continue;
            izpackDistro = defaultArtifact.getFile();
            break;
        }
        File izpackDirectory = new File(this.outputDirectory, "izpack");
        if (izpackDistro == null) {
            throw new MojoExecutionException("Missing plugin dependency 'izpack-distro'");
        }
        if (izpackDirectory.exists()) {
            this.getLog().warn((CharSequence)"izpack distro already upacked to build dir? skipping.");
        } else {
            this.getLog().info((CharSequence)"unpacking izpack distribution to build directory ...");
            FileUtils.unpackArchive(izpackDistro, izpackDirectory);
        }
        CompilerConfig.setIzpackHome((String)izpackDirectory.getAbsolutePath());
        for (CustomAction customAction : this.customActions) {
            name = customAction.getName();
            versionlessKey = customAction.getVersionlessKey();
            String classifer = customAction.getClassifier();
            if (!name.endsWith(".jar")) {
                name = name + ".jar";
            }
            targetFile = new File(izpackDirectory, "bin/customActions/" + name);
            this.copyIzPackDependency(versionlessKey, classifer, "jar", targetFile);
        }
        for (Resource resource : this.resources) {
            name = resource.getName();
            versionlessKey = resource.getVersionlessKey();
            classifier = resource.getClassifier();
            String type = resource.getType();
            File targetFile2 = new File(izpackDirectory, "res/" + name);
            this.copyIzPackDependency(versionlessKey, classifier, type, targetFile2);
        }
        for (Panel panel : this.panels) {
            name = panel.getName();
            versionlessKey = panel.getVersionlessKey();
            classifier = panel.getClassifier();
            if (!name.endsWith(".jar")) {
                name = name + ".jar";
            }
            targetFile = new File(izpackDirectory, "bin/panels/" + name);
            this.copyIzPackDependency(versionlessKey, classifier, "jar", targetFile);
        }
        for (InstallationJar jar : this.installationJars) {
            name = jar.getName();
            versionlessKey = jar.getVersionlessKey();
            classifier = jar.getClassifier();
            if (!name.endsWith(".jar")) {
                name = name + ".jar";
            }
            targetFile = new File(izpackDirectory, "lib/" + name);
            this.copyIzPackDependency(versionlessKey, classifier, "jar", targetFile);
        }
        File targetFile3 = new File(this.outputDirectory, this.finalName + "-install.jar");
        CompilerConfig compilerConfig = null;
        try {
            this.getLog().info((CharSequence)"compiling izpack installation ...");
            String targetPath = targetFile3.getAbsolutePath();
            compilerConfig = new CompilerConfig(input, this.outputDirectory, this.installationType, targetPath);
            compilerConfig.executeCompiler();
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error compiling izpack installation file. " + ex);
        }
        this.projectHelper.attachArtifact(this.project, "jar", "install", targetFile3);
        String classifier2 = null;
        File outputDir = new File(this.outputDirectory);
        for (File file : list = outputDir.listFiles()) {
            String name2 = file.getName();
            int begin = name2.indexOf("install.pack");
            int end = name2.indexOf("." + this.packFileExtensionType);
            if (begin <= -1 || end <= -1) continue;
            classifier2 = name2.substring(begin, end);
            this.projectHelper.attachArtifact(this.project, this.packFileExtensionType, classifier2, file);
        }
    }

    private File interpolateFile(String input, Model model) throws Exception {
        if (!new File(input).exists()) {
            throw new FileNotFoundException(new File(input).getAbsolutePath());
        }
        HashMap<Object, Object> buildContext = new HashMap<Object, Object>(System.getProperties());
        File projectDir = this.project.getBasedir();
        buildContext.put("basedir", this.project.getBasedir().getAbsolutePath());
        DefaultPathTranslator pathTranslator = new DefaultPathTranslator();
        Build build = model.getBuild();
        buildContext.put("build.directory", pathTranslator.alignToBaseDirectory(build.getDirectory(), projectDir));
        buildContext.put("build.outputDirectory", pathTranslator.alignToBaseDirectory(build.getOutputDirectory(), projectDir));
        buildContext.put("build.testOutputDirectory", pathTranslator.alignToBaseDirectory(build.getTestOutputDirectory(), projectDir));
        buildContext.put("build.sourceDirectory", pathTranslator.alignToBaseDirectory(build.getSourceDirectory(), projectDir));
        buildContext.put("build.testSourceDirectory", pathTranslator.alignToBaseDirectory(build.getTestSourceDirectory(), projectDir));
        String config = IOUtils.toString((InputStream)new FileInputStream(input), (String)"UTF-8");
        InterpolationHelper helper = new InterpolationHelper(this.getLog(), buildContext);
        config = helper.interpolate(config, model);
        File temp = File.createTempFile("izpack", ".xml");
        temp.deleteOnExit();
        FileOutputStream out = new FileOutputStream(temp);
        ByteArrayInputStream in = new ByteArrayInputStream(config.getBytes("UTF-8"));
        IOUtils.copy((InputStream)in, (OutputStream)out);
        out.flush();
        out.close();
        return temp;
    }

    private void copyIzPackDependency(String versionlessKey, String classifier, String type, File targetFile) throws MojoExecutionException {
        ScopeArtifactFilter runtimeFilter = new ScopeArtifactFilter("runtime");
        Iterator itr = this.project.getArtifacts().iterator();
        File artifact = null;
        String artifactID = null;
        while (itr.hasNext()) {
            String groupID;
            String key;
            Artifact dependency = (Artifact)itr.next();
            if (!runtimeFilter.include(dependency) || !dependency.getType().equals(type) || classifier != null && (dependency.getClassifier() == null || !dependency.getClassifier().equals(classifier)) || !(key = ArtifactUtils.versionlessKey((String)(groupID = dependency.getGroupId()), (String)(artifactID = dependency.getArtifactId()))).equals(versionlessKey)) continue;
            artifact = dependency.getFile();
            break;
        }
        if (artifact == null) {
            this.getLog().warn((CharSequence)("izpack resource " + versionlessKey + ":" + classifier + ":" + type + " not defined as a 'runtime' scoped project dependency."));
        } else {
            FileUtils.copyFile(artifact, targetFile);
        }
    }
}

