/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.eoa.system.plugin.izpack.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.plugin.MojoExecutionException;
import org.bluestemsoftware.open.eoa.system.plugin.izpack.util.FileFilterImpl;

public class FileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unpackArchive(File source, File target) throws MojoExecutionException {
        target.mkdir();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(source);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File file = new File(target, File.separator + entry.getName());
                if (entry.isDirectory() && !file.exists()) {
                    file.mkdirs();
                    continue;
                }
                file.getParentFile().mkdirs();
                InputStream in = null;
                OutputStream out = null;
                try {
                    in = zipFile.getInputStream(entry);
                    out = new BufferedOutputStream(new FileOutputStream(file));
                    byte[] buffer = new byte[4096];
                    int length = 0;
                    while (length >= 0) {
                        out.write(buffer, 0, length);
                        length = in.read(buffer);
                    }
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                    if (out == null) continue;
                    out.close();
                }
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error unpacking archive " + source.getAbsolutePath() + " to " + target.getAbsolutePath(), ex);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Error cleaning up. " + ex.toString());
                }
            }
        }
    }

    public static File copyDir(File source, File target) throws MojoExecutionException {
        target.mkdir();
        File[] entries = source.listFiles(new FileFilterImpl());
        for (int i = 0; i < entries.length; ++i) {
            File entry = entries[i];
            File file = new File(target, File.separator + entry.getName());
            if (entry.isDirectory()) {
                FileUtils.copyDir(entry, file);
                continue;
            }
            FileInputStream in = null;
            OutputStream out = null;
            try {
                in = new FileInputStream(entry);
                out = new BufferedOutputStream(new FileOutputStream(file));
                byte[] buffer = new byte[4096];
                int length = 0;
                while (length >= 0) {
                    out.write(buffer, 0, length);
                    length = ((InputStream)in).read(buffer);
                }
                continue;
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Error copying directory. " + ex);
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException ignore) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        return target;
    }

    public static void removeDir(File target) throws Exception {
        File[] entries = target.listFiles();
        if (entries == null) {
            return;
        }
        for (int i = 0; i < entries.length; ++i) {
            File entry = entries[i];
            if (entry.isDirectory()) {
                FileUtils.removeDir(entry);
                continue;
            }
            entry.delete();
        }
        target.delete();
    }

    public static void copyFile(File source, File target) throws MojoExecutionException {
        InputStream in = null;
        OutputStream out = null;
        try {
            if (target.getParentFile() != null) {
                target.getParentFile().mkdirs();
            }
            in = new FileInputStream(source);
            out = new BufferedOutputStream(new FileOutputStream(target));
            byte[] buffer = new byte[4096];
            int length = 0;
            while (length >= 0) {
                out.write(buffer, 0, length);
                length = in.read(buffer);
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error copying file. " + ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignore) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ignore) {}
            }
        }
    }
}

