/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.eoa.system.plugin.izpack.util;

import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.interpolation.ModelInterpolationException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.introspection.ReflectionValueExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterpolationHelper {
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("\\$\\{(pom\\.|project\\.|env\\.)?([^}]+)\\}");
    private Properties envars;
    private Map<String, String> buildContext;
    private Log log;

    public InterpolationHelper(Log log, Map<String, String> buildContext) {
        this.log = log;
        this.buildContext = buildContext;
        this.envars = System.getProperties();
    }

    public String interpolate(String src, Model model) throws ModelInterpolationException {
        boolean isSnapshotModel = (model.getVersion() == null ? (model.getParent() == null ? "" : model.getParent().getVersion()) : model.getVersion()).indexOf("SNAPSHOT") >= 0;
        String result = src;
        Matcher matcher = EXPRESSION_PATTERN.matcher(result);
        while (matcher.find()) {
            boolean isPomExpression;
            String wholeExpr = matcher.group(0);
            String prefix = matcher.group(1);
            String realExpr = matcher.group(2);
            prefix = prefix == null ? "" : prefix;
            Object value = null;
            boolean bl = isPomExpression = "pom.".equals(prefix) || "project.".equals(prefix);
            if (this.buildContext.get(realExpr) == null && this.buildContext.containsKey(realExpr)) continue;
            if (isPomExpression) {
                value = InterpolationHelper.getValueFromModel(realExpr, model, wholeExpr, this.log);
            }
            if (value == null) {
                value = this.buildContext.get(realExpr);
            }
            if (value == null) {
                value = model.getProperties().getProperty(realExpr);
            }
            if (value == null) {
                value = this.envars.getProperty(realExpr);
            }
            if (value == null && prefix.length() == 0) {
                value = InterpolationHelper.getValueFromModel(realExpr, model, wholeExpr, this.log);
                if (isSnapshotModel && value != null && this.log != null) {
                    this.log.debug((CharSequence)("Expression: " + wholeExpr + " is missing its prefix. Instead, use ${pom." + realExpr + "} (model: " + model.getId() + ")"));
                }
            }
            if (value == null) continue;
            if (StringUtils.replace((String)value.toString(), (String)"${project.", (String)"${pom.").indexOf(StringUtils.replace((String)wholeExpr, (String)"${project.", (String)"${pom.")) > -1) {
                throw new ModelInterpolationException(wholeExpr, "Expression value '" + value + "' references itself in '" + model.getId() + "'.");
            }
            result = StringUtils.replace((String)result, (String)wholeExpr, (String)value.toString());
            matcher.reset(result);
        }
        return result;
    }

    private static Object getValueFromModel(String realExpr, Model model, String wholeExpr, Log log) {
        try {
            return ReflectionValueExtractor.evaluate((String)realExpr, (Object)model, (boolean)false);
        }
        catch (Exception e) {
            log.debug((CharSequence)("POM interpolation cannot proceed with expression: " + wholeExpr + ". Skipping..."), (Throwable)e);
            return null;
        }
    }
}

