/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Vector;
import javax.swing.JComponent;

public class MultiLineLabel
extends JComponent {
    private static final long serialVersionUID = 4051045255031894837L;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int DEFAULT_MARGIN = 10;
    public static final int DEFAULT_ALIGN = 0;
    public static final int LEAST_ALLOWED = 200;
    private static final int FOUND = 0;
    private static final int NOT_FOUND = 1;
    private static final int NOT_DONE = 0;
    private static final int DONE = 1;
    private static final char[] WHITE_SPACE = new char[]{' ', '\n', '\t'};
    private static final char[] SPACES = new char[]{' ', '\t'};
    private static final char NEW_LINE = '\n';
    protected Vector<String> line = new Vector();
    protected String labelText;
    protected int numLines;
    protected int marginHeight;
    protected int marginWidth;
    protected int lineHeight;
    protected int lineAscent;
    protected int lineDescent;
    protected int[] lineWidth;
    protected int maxWidth;
    private int maxAllowed = 200;
    private boolean maxAllowedSet = false;
    protected int alignment = 0;

    public MultiLineLabel(String text, int horMargin, int vertMargin, int maxWidth, int justify) {
        this.labelText = text;
        this.marginWidth = horMargin;
        this.marginHeight = vertMargin;
        this.maxAllowed = maxWidth;
        this.maxAllowedSet = true;
        this.alignment = justify;
    }

    public MultiLineLabel(String label, int marginWidth, int marginHeight) {
        this.labelText = label;
        this.marginWidth = marginWidth;
        this.marginHeight = marginHeight;
    }

    public MultiLineLabel(String label, int alignment) {
        this.labelText = label;
        this.alignment = alignment;
    }

    public MultiLineLabel(String label) {
        this.labelText = label;
    }

    int getPosition(String target, int start, char[] source, int mode) {
        int targetEnd = target.length() - 1;
        int sourceLength = source.length;
        int position = start;
        if (mode == 0) {
            boolean status = false;
            while (!status) {
                if (++position >= targetEnd) {
                    return targetEnd;
                }
                char temp = target.charAt(position);
                for (int scan = 0; scan < sourceLength; ++scan) {
                    if (source[scan] != temp) continue;
                    status = true;
                }
            }
            return position;
        }
        if (mode == 1) {
            boolean status = false;
            while (!status) {
                if (++position >= targetEnd) {
                    return targetEnd;
                }
                char temp = target.charAt(position);
                status = true;
                for (int scan = 0; scan < sourceLength; ++scan) {
                    if (source[scan] != temp) continue;
                    status = false;
                }
            }
            return position;
        }
        return 0;
    }

    int breakWord(String word, FontMetrics fm) {
        int width = 0;
        int currentPos = 0;
        int endPos = word.length() - 1;
        if (endPos <= 0) {
            return currentPos;
        }
        while (width < this.maxAllowed && currentPos < endPos) {
            width = fm.stringWidth(this.labelText.substring(0, ++currentPos));
        }
        if (currentPos != endPos) {
            --currentPos;
        }
        return currentPos;
    }

    private void divideLabel() {
        int startPos;
        int currentPos;
        this.line.clear();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int lastPos = currentPos = (startPos = 0);
        int endPos = this.labelText.length() - 1;
        while (currentPos < endPos) {
            String s;
            int width = 0;
            while (width < this.maxAllowed && currentPos < endPos && this.labelText.charAt(currentPos) != '\n') {
                lastPos = currentPos;
                currentPos = this.getPosition(this.labelText, currentPos, WHITE_SPACE, 0);
                width = fm.stringWidth(this.labelText.substring(startPos, currentPos));
            }
            if (this.labelText.charAt(currentPos) == '\n') {
                lastPos = currentPos;
            }
            if (currentPos == endPos && width <= this.maxAllowed) {
                lastPos = currentPos;
                s = this.labelText.substring(startPos);
                this.line.addElement(s);
            } else {
                if (lastPos == startPos) {
                    lastPos = startPos + this.breakWord(this.labelText.substring(startPos, currentPos), fm);
                }
                s = this.labelText.substring(startPos, lastPos);
                this.line.addElement(s);
            }
            currentPos = startPos = this.getPosition(this.labelText, lastPos, SPACES, 1);
        }
        this.numLines = this.line.size();
        this.lineWidth = new int[this.numLines];
    }

    protected void measure() {
        if (!this.maxAllowedSet) {
            this.maxAllowed = this.getParent().getSize().width;
        }
        if (this.maxAllowed < 20) {
            return;
        }
        FontMetrics fm = this.getFontMetrics(this.getFont());
        if (fm == null) {
            return;
        }
        this.divideLabel();
        this.lineHeight = fm.getHeight();
        this.lineDescent = fm.getDescent();
        this.maxWidth = 0;
        for (int i = 0; i < this.numLines; ++i) {
            this.lineWidth[i] = fm.stringWidth(this.line.elementAt(i));
            if (this.lineWidth[i] <= this.maxWidth) continue;
            this.maxWidth = this.lineWidth[i];
        }
    }

    public void paint(Graphics graphics) {
        this.measure();
        Dimension d = this.getSize();
        int y = this.lineAscent + (d.height - this.numLines * this.lineHeight) / 2;
        for (int i = 0; i < this.numLines; ++i) {
            int x;
            y += this.lineHeight;
            switch (this.alignment) {
                case 0: {
                    x = this.marginWidth;
                    break;
                }
                case 1: {
                    x = (d.width - this.lineWidth[i]) / 2;
                    break;
                }
                case 2: {
                    x = d.width - this.marginWidth - this.lineWidth[i];
                    break;
                }
                default: {
                    x = (d.width - this.lineWidth[i]) / 2;
                }
            }
            graphics.drawString(this.line.elementAt(i), x, y);
        }
    }

    public void setText(String labelText) {
        this.labelText = labelText;
        this.repaint();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.repaint();
    }

    public void setColor(Color color) {
        super.setForeground(color);
        this.repaint();
    }

    public void setJustify(int alignment) {
        this.alignment = alignment;
        this.repaint();
    }

    public void setMaxWidth(int width) {
        this.maxAllowed = width;
        this.maxAllowedSet = true;
        this.repaint();
    }

    public void setMarginWidth(int margin) {
        this.marginWidth = margin;
        this.repaint();
    }

    public void setMarginHeight(int margin) {
        this.marginHeight = margin;
        this.repaint();
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.maxAllowed = width;
        this.maxAllowedSet = true;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public int getMarginWidth() {
        return this.marginWidth;
    }

    public int getMarginHeight() {
        return this.marginHeight;
    }

    public Dimension getPreferredSize() {
        this.measure();
        return new Dimension(this.maxAllowed, this.numLines * (this.lineHeight + this.lineAscent + this.lineDescent) + 2 * this.marginHeight);
    }

    public Dimension getMinimumSize() {
        this.measure();
        return new Dimension(this.maxAllowed, this.numLines * (this.lineHeight + this.lineAscent + this.lineDescent) + 2 * this.marginHeight);
    }

    public void addNotify() {
        super.addNotify();
    }
}

