/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j.binding;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import net.sf.launch4j.binding.Binding;
import net.sf.launch4j.binding.BindingException;
import net.sf.launch4j.binding.IValidatable;
import org.apache.commons.beanutils.PropertyUtils;

public class JListBinding
implements Binding {
    private final String _property;
    private final JList _list;
    private final Color _validColor;

    public JListBinding(String property, JList list) {
        if (property == null || list == null) {
            throw new NullPointerException();
        }
        if (property.equals("")) {
            throw new IllegalArgumentException();
        }
        this._property = property;
        this._list = list;
        this._validColor = this._list.getBackground();
    }

    public String getProperty() {
        return this._property;
    }

    public void clear(IValidatable bean) {
        this._list.setModel(new DefaultListModel());
    }

    public void put(IValidatable bean) {
        try {
            List list = (List)PropertyUtils.getProperty((Object)bean, (String)this._property);
            DefaultListModel model = new DefaultListModel();
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                model.addElement(iter.next());
            }
            this._list.setModel(model);
        }
        catch (Exception e) {
            throw new BindingException(e);
        }
    }

    public void get(IValidatable bean) {
        try {
            DefaultListModel model = (DefaultListModel)this._list.getModel();
            int size = model.getSize();
            ArrayList list = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                list.add(model.get(i));
            }
            PropertyUtils.setProperty((Object)bean, (String)this._property, list);
        }
        catch (Exception e) {
            throw new BindingException(e);
        }
    }

    public void markValid() {
        this._list.setBackground(this._validColor);
        this._list.requestFocusInWindow();
    }

    public void markInvalid() {
        this._list.setBackground(Binding.INVALID_COLOR);
    }

    public void setEnabled(boolean enabled) {
        this._list.setEnabled(enabled);
    }
}

