/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j.config;

import java.io.File;
import java.util.List;
import net.sf.launch4j.binding.IValidatable;
import net.sf.launch4j.binding.Validator;
import net.sf.launch4j.config.ClassPath;
import net.sf.launch4j.config.Jre;
import net.sf.launch4j.config.LdDefaults;
import net.sf.launch4j.config.Messages;
import net.sf.launch4j.config.Splash;
import net.sf.launch4j.config.VersionInfo;

public class Config
implements IValidatable {
    public static final String HEADER = "header";
    public static final String JAR = "jar";
    public static final String OUTFILE = "outfile";
    public static final String ERR_TITLE = "errTitle";
    public static final String JAR_ARGS = "jarArgs";
    public static final String CHDIR = "chdir";
    public static final String CUSTOM_PROC_NAME = "customProcName";
    public static final String STAY_ALIVE = "stayAlive";
    public static final String ICON = "icon";
    public static final String GUI_HEADER = "gui";
    public static final String CONSOLE_HEADER = "console";
    private static final String[] HEADER_TYPES = new String[]{"gui", "console"};
    private boolean dontWrapJar;
    private String headerType = "gui";
    private List headerObjects;
    private List libs;
    private File jar;
    private File outfile;
    private String errTitle;
    private String cmdLine;
    private String chdir;
    private boolean customProcName;
    private boolean stayAlive;
    private File icon;
    private List variables;
    private ClassPath classPath;
    private Jre jre;
    private Splash splash;
    private VersionInfo versionInfo;

    public void checkInvariants() {
        Validator.checkTrue(this.outfile != null && this.outfile.getPath().endsWith(".exe"), OUTFILE, Messages.getString("Config.specify.output.exe"));
        if (this.dontWrapJar) {
            if (this.jar != null && !this.jar.getPath().equals("")) {
                Validator.checkRelativeWinPath(this.jar.getPath(), JAR, Messages.getString("Config.application.jar.path"));
            } else {
                Validator.checkTrue(this.classPath != null, "classPath", Messages.getString("ClassPath.or.jar"));
            }
        } else {
            Validator.checkFile(this.jar, JAR, Messages.getString("Config.application.jar"));
        }
        if (!Validator.isEmpty(this.chdir)) {
            Validator.checkRelativeWinPath(this.chdir, CHDIR, Messages.getString("Config.chdir.relative"));
            Validator.checkFalse(this.chdir.toLowerCase().equals("true") || this.chdir.toLowerCase().equals("false"), CHDIR, Messages.getString("Config.chdir.path"));
        }
        Validator.checkOptFile(this.icon, ICON, Messages.getString("Config.icon"));
        Validator.checkOptString(this.cmdLine, 8192, JAR_ARGS, Messages.getString("Config.jar.arguments"));
        Validator.checkOptString(this.errTitle, 128, ERR_TITLE, Messages.getString("Config.error.title"));
        Validator.checkIn(this.getHeaderType(), HEADER_TYPES, "headerType", Messages.getString("Config.header.type"));
        Validator.checkFalse(this.getHeaderType().equals(CONSOLE_HEADER) && this.splash != null, "headerType", Messages.getString("Config.splash.not.impl.by.console.hdr"));
        Validator.checkOptStrings(this.variables, 30719, 30719, "[^=%\t]+=[^=\t]+", "variables", Messages.getString("Config.variables"), Messages.getString("Config.variables.err"));
        this.jre.checkInvariants();
    }

    public void validate() {
        this.checkInvariants();
        if (this.classPath != null) {
            this.classPath.checkInvariants();
        }
        if (this.splash != null) {
            this.splash.checkInvariants();
        }
        if (this.versionInfo != null) {
            this.versionInfo.checkInvariants();
        }
    }

    public String getChdir() {
        return this.chdir;
    }

    public void setChdir(String chdir) {
        this.chdir = chdir;
    }

    public String getCmdLine() {
        return this.cmdLine;
    }

    public void setCmdLine(String cmdLine) {
        this.cmdLine = cmdLine;
    }

    public String getErrTitle() {
        return this.errTitle;
    }

    public void setErrTitle(String errTitle) {
        this.errTitle = errTitle;
    }

    public String getHeaderType() {
        return this.headerType.toLowerCase();
    }

    public void setHeaderType(String headerType) {
        this.headerType = headerType;
    }

    public int getHeaderTypeIndex() {
        String type = this.getHeaderType();
        for (int i = 0; i < HEADER_TYPES.length; ++i) {
            if (!type.equals(HEADER_TYPES[i])) continue;
            return i;
        }
        return 0;
    }

    public void setHeaderTypeIndex(int headerTypeIndex) {
        this.headerType = HEADER_TYPES[headerTypeIndex];
    }

    public boolean isCustomHeaderObjects() {
        return this.headerObjects != null && !this.headerObjects.isEmpty();
    }

    public List getHeaderObjects() {
        return this.isCustomHeaderObjects() ? this.headerObjects : (this.getHeaderType().equals(GUI_HEADER) ? LdDefaults.GUI_HEADER_OBJECTS : LdDefaults.CONSOLE_HEADER_OBJECTS);
    }

    public void setHeaderObjects(List headerObjects) {
        this.headerObjects = headerObjects;
    }

    public boolean isCustomLibs() {
        return this.libs != null && !this.libs.isEmpty();
    }

    public List getLibs() {
        return this.isCustomLibs() ? this.libs : LdDefaults.LIBS;
    }

    public void setLibs(List libs) {
        this.libs = libs;
    }

    public File getIcon() {
        return this.icon;
    }

    public void setIcon(File icon) {
        this.icon = icon;
    }

    public File getJar() {
        return this.jar;
    }

    public void setJar(File jar) {
        this.jar = jar;
    }

    public List getVariables() {
        return this.variables;
    }

    public void setVariables(List variables) {
        this.variables = variables;
    }

    public ClassPath getClassPath() {
        return this.classPath;
    }

    public void setClassPath(ClassPath classpath) {
        this.classPath = classpath;
    }

    public Jre getJre() {
        return this.jre;
    }

    public void setJre(Jre jre) {
        this.jre = jre;
    }

    public File getOutfile() {
        return this.outfile;
    }

    public void setOutfile(File outfile) {
        this.outfile = outfile;
    }

    public boolean isCustomProcName() {
        return this.customProcName;
    }

    public void setCustomProcName(boolean customProcName) {
        this.customProcName = customProcName;
    }

    public Splash getSplash() {
        return this.splash;
    }

    public void setSplash(Splash splash) {
        this.splash = splash;
    }

    public boolean isStayAlive() {
        return this.stayAlive;
    }

    public void setStayAlive(boolean stayAlive) {
        this.stayAlive = stayAlive;
    }

    public VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    public void setVersionInfo(VersionInfo versionInfo) {
        this.versionInfo = versionInfo;
    }

    public boolean isDontWrapJar() {
        return this.dontWrapJar;
    }

    public void setDontWrapJar(boolean dontWrapJar) {
        this.dontWrapJar = dontWrapJar;
    }
}

