/*
 * Decompiled with CFR 0.152.
 */
package com.akathist.maven.plugins.launch4j;

import com.akathist.maven.plugins.launch4j.ClassPath;
import com.akathist.maven.plugins.launch4j.Jre;
import com.akathist.maven.plugins.launch4j.MavenLog;
import com.akathist.maven.plugins.launch4j.Splash;
import com.akathist.maven.plugins.launch4j.VersionInfo;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import net.sf.launch4j.Builder;
import net.sf.launch4j.BuilderException;
import net.sf.launch4j.config.Config;
import net.sf.launch4j.config.ConfigPersister;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;

public class Launch4jMojo
extends AbstractMojo {
    private Set dependencies;
    private MavenProject project;
    private List plugins;
    private ArchiverManager archiverManager;
    private ArtifactFactory factory;
    private ArtifactRepository localRepository;
    private ArtifactResolver resolver;
    private File basedir;
    private String headerType;
    private File outfile;
    private String jar;
    private boolean dontWrapJar;
    private String errTitle;
    private String cmdLine;
    private String chdir;
    private boolean customProcName;
    private boolean stayAlive;
    private File icon;
    private List objs;
    private List libs;
    private List vars;
    private Jre jre;
    private ClassPath classPath;
    private Splash splash;
    private VersionInfo versionInfo;

    private File getJar() {
        File f = new File(this.jar);
        if (f.isAbsolute()) {
            return f;
        }
        return new File(this.getBaseDir(), this.jar);
    }

    public void execute() throws MojoExecutionException {
        if (this.getLog().isDebugEnabled()) {
            this.printState();
        }
        Config c = new Config();
        c.setHeaderType(this.headerType);
        c.setOutfile(this.outfile);
        c.setJar(this.getJar());
        c.setDontWrapJar(this.dontWrapJar);
        c.setErrTitle(this.errTitle);
        c.setCmdLine(this.cmdLine);
        c.setChdir(this.chdir);
        c.setCustomProcName(this.customProcName);
        c.setStayAlive(this.stayAlive);
        c.setIcon(this.icon);
        c.setHeaderObjects(this.objs);
        c.setLibs(this.libs);
        c.setVariables(this.vars);
        if (this.classPath != null) {
            c.setClassPath(this.classPath.toL4j(this.dependencies));
        }
        if (this.jre != null) {
            c.setJre(this.jre.toL4j());
        }
        if (this.splash != null) {
            c.setSplash(this.splash.toL4j());
        }
        if (this.versionInfo != null) {
            c.setVersionInfo(this.versionInfo.toL4j());
        }
        ConfigPersister.getInstance().setAntConfig(c, this.getBaseDir());
        Builder b = new Builder(new MavenLog(this.getLog()));
        File workdir = this.setupBuildEnvironment();
        b.setBasedir(workdir);
        try {
            b.build();
        }
        catch (BuilderException e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Failed to build the executable; please verify your configuration.", (Exception)e);
        }
    }

    private File setupBuildEnvironment() throws MojoExecutionException {
        Artifact binaryBits = this.chooseBinaryBits();
        this.retrieveBinaryBits(binaryBits);
        return this.unpackWorkDir(binaryBits);
    }

    private File unpackWorkDir(Artifact a) throws MojoExecutionException {
        String version = a.getVersion();
        File platJar = a.getFile();
        File dest = platJar.getParentFile();
        File marker = new File(dest, platJar.getName() + ".unpacked");
        if (marker.exists() && marker.lastModified() > platJar.lastModified()) {
            this.getLog().info((CharSequence)("Platform-specific work directory already exists: " + dest.getAbsolutePath()));
        } else {
            try {
                UnArchiver un = this.archiverManager.getUnArchiver(platJar);
                un.setSourceFile(platJar);
                un.setDestDirectory(dest);
                un.extract();
            }
            catch (NoSuchArchiverException e) {
                this.getLog().error((Throwable)e);
                throw new MojoExecutionException("Don't know how to unarchive files like " + platJar, (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException("IO Error unarchiving " + platJar, (Exception)e);
            }
            catch (ArchiverException e) {
                throw new MojoExecutionException("Error unarchiving " + platJar, (Exception)((Object)e));
            }
            try {
                marker.createNewFile();
                marker.setLastModified(new Date().getTime());
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Trouble creating marker file " + marker), (Throwable)e);
            }
        }
        String n = platJar.getName();
        File workdir = new File(dest, n.substring(0, n.length() - 4));
        this.setPermissions(workdir);
        return workdir;
    }

    private void setPermissions(File workdir) throws MojoExecutionException {
        if (!System.getProperty("os.name").startsWith("Windows")) {
            Runtime r = Runtime.getRuntime();
            try {
                r.exec("chmod 755 " + workdir + "/bin/ld").waitFor();
                r.exec("chmod 755 " + workdir + "/bin/windres").waitFor();
            }
            catch (InterruptedException e) {
                this.getLog().warn((CharSequence)"Interrupted while chmodding platform-specific binaries", (Throwable)e);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)"Unable to set platform-specific binaries to 775", (Throwable)e);
            }
        }
    }

    private void retrieveBinaryBits(Artifact a) throws MojoExecutionException {
        try {
            this.resolver.resolve(a, this.project.getRemoteArtifactRepositories(), this.localRepository);
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Can't find platform-specific components", (Exception)((Object)e));
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Can't retrieve platform-specific components", (Exception)((Object)e));
        }
    }

    private Artifact chooseBinaryBits() throws MojoExecutionException {
        String plat;
        String os = System.getProperty("os.name");
        this.getLog().debug((CharSequence)("OS = " + os));
        if (os.startsWith("Windows")) {
            plat = "win32";
        } else if ("Linux".equals(os)) {
            plat = "linux";
        } else if ("Solaris".equals(os) || "SunOS".equals(os)) {
            plat = "solaris";
        } else if ("Mac OS X".equals(os)) {
            plat = "mac";
        } else {
            throw new MojoExecutionException("Sorry, Launch4j doesn't support the '" + os + "' OS.");
        }
        return this.factory.createArtifactWithClassifier("org.bluestemsoftware.open.maven.plugin", "launch4j-plugin", this.getMyVersion(), "jar", "workdir-" + plat);
    }

    private String getMyVersion() throws MojoExecutionException {
        Log log = this.getLog();
        log.debug((CharSequence)"searching for launch4j plugin");
        for (Plugin p : this.plugins) {
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)(p.getGroupId() + " ## " + p.getArtifactId() + " ## " + p.getVersion()));
            }
            if (!"launch4j-plugin".equals(p.getArtifactId()) || !"org.bluestemsoftware.open.maven.plugin".equals(p.getGroupId())) continue;
            String v = p.getVersion();
            log.debug((CharSequence)("Found launch4j version " + v));
            return v;
        }
        throw new MojoExecutionException("Launch4j isn't among this project's plugins. How can that be?");
    }

    private File getBaseDir() {
        return this.basedir;
    }

    private void printState() {
        Log log = this.getLog();
        log.debug((CharSequence)("headerType = " + this.headerType));
        log.debug((CharSequence)("outfile = " + this.outfile));
        log.debug((CharSequence)("jar = " + this.jar));
        log.debug((CharSequence)("dontWrapJar = " + this.dontWrapJar));
        log.debug((CharSequence)("errTitle = " + this.errTitle));
        log.debug((CharSequence)("cmdLine = " + this.cmdLine));
        log.debug((CharSequence)("chdir = " + this.chdir));
        log.debug((CharSequence)("customProcName = " + this.customProcName));
        log.debug((CharSequence)("stayAlive = " + this.stayAlive));
        log.debug((CharSequence)("icon = " + this.icon));
        log.debug((CharSequence)("objs = " + this.objs));
        log.debug((CharSequence)("libs = " + this.libs));
        log.debug((CharSequence)("vars = " + this.vars));
        if (this.jre != null) {
            log.debug((CharSequence)("jre.path = " + this.jre.path));
            log.debug((CharSequence)("jre.minVersion = " + this.jre.minVersion));
            log.debug((CharSequence)("jre.maxVersion = " + this.jre.maxVersion));
            log.debug((CharSequence)("jre.dontUsePrivateJres = " + this.jre.dontUsePrivateJres));
            log.debug((CharSequence)("jre.initialHeapSize = " + this.jre.initialHeapSize));
            log.debug((CharSequence)("jre.maxHeapSize = " + this.jre.maxHeapSize));
            log.debug((CharSequence)("jre.opts = " + this.jre.opts));
        } else {
            log.debug((CharSequence)"jre = null");
        }
        if (this.classPath != null) {
            log.debug((CharSequence)("classPath.mainClass = " + this.classPath.mainClass));
            log.debug((CharSequence)("classPath.addDependencies = " + this.classPath.addDependencies));
            log.debug((CharSequence)("classPath.jarLocation = " + this.classPath.jarLocation));
            log.debug((CharSequence)("classPath.preCp = " + this.classPath.preCp));
            log.debug((CharSequence)("classPath.postCp = " + this.classPath.postCp));
        } else {
            log.info((CharSequence)"classpath = null");
        }
        if (this.splash != null) {
            log.debug((CharSequence)("splash.file = " + this.splash.file));
            log.debug((CharSequence)("splash.waitForWindow = " + this.splash.waitForWindow));
            log.debug((CharSequence)("splash.timeout = " + this.splash.timeout));
            log.debug((CharSequence)("splash.timoutErr = " + this.splash.timeoutErr));
        } else {
            log.debug((CharSequence)"splash = null");
        }
        if (this.versionInfo != null) {
            log.debug((CharSequence)("versionInfo.fileVersion = " + this.versionInfo.fileVersion));
            log.debug((CharSequence)("versionInfo.txtFileVersion = " + this.versionInfo.txtFileVersion));
            log.debug((CharSequence)("versionInfo.fileDescription = " + this.versionInfo.fileDescription));
            log.debug((CharSequence)("versionInfo.copyright = " + this.versionInfo.copyright));
            log.debug((CharSequence)("versionInfo.productVersion = " + this.versionInfo.productVersion));
            log.debug((CharSequence)("versionInfo.txtProductVersion = " + this.versionInfo.txtProductVersion));
            log.debug((CharSequence)("versionInfo.productName = " + this.versionInfo.productName));
            log.debug((CharSequence)("versionInfo.companyName = " + this.versionInfo.companyName));
            log.debug((CharSequence)("versionInfo.internalName = " + this.versionInfo.internalName));
            log.debug((CharSequence)("versionInfo.originalFilename = " + this.versionInfo.originalFilename));
        } else {
            log.debug((CharSequence)"versionInfo = null");
        }
    }
}

