/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import net.sf.launch4j.BuilderException;
import net.sf.launch4j.Cmd;
import net.sf.launch4j.ExecException;
import net.sf.launch4j.Log;
import net.sf.launch4j.Messages;
import net.sf.launch4j.RcBuilder;
import net.sf.launch4j.Util;
import net.sf.launch4j.binding.InvariantViolationException;
import net.sf.launch4j.config.Config;
import net.sf.launch4j.config.ConfigPersister;

public class Builder {
    private final Log _log;
    private File _basedir;

    public void setBasedir(File f) {
        this._basedir = f;
    }

    public Builder(Log log) {
        this._log = log;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File build() throws BuilderException {
        File file;
        Config c = ConfigPersister.getInstance().getConfig();
        try {
            c.validate();
        }
        catch (InvariantViolationException e) {
            throw new BuilderException(e.getMessage());
        }
        File rc = null;
        File ro = null;
        File outfile = null;
        FileInputStream is = null;
        FileOutputStream os = null;
        RcBuilder rcb = new RcBuilder();
        try {
            if (this._basedir == null) {
                this._basedir = Util.getJarBasedir();
            }
            rc = rcb.build(c);
            ro = Util.createTempFile("o");
            outfile = ConfigPersister.getInstance().getOutputFile();
            Cmd resCmd = new Cmd(this._basedir);
            resCmd.addExe("windres").add(Util.WINDOWS_OS ? "--preprocessor=type" : "--preprocessor=cat").add("-J rc -O coff -F pe-i386").addAbsFile(rc).addAbsFile(ro);
            this._log.append(Messages.getString("Builder.compiling.resources"));
            resCmd.exec(this._log);
            Cmd ldCmd = new Cmd(this._basedir);
            ldCmd.addExe("ld").add("-mi386pe").add("--oformat pei-i386").add(c.getHeaderType().equals("gui") ? "--subsystem windows" : "--subsystem console").add("-s").addFiles(c.getHeaderObjects()).addAbsFile(ro).addFiles(c.getLibs()).add("-o").addAbsFile(outfile);
            this._log.append(Messages.getString("Builder.linking"));
            ldCmd.exec(this._log);
            if (!c.isDontWrapJar()) {
                int len;
                this._log.append(Messages.getString("Builder.wrapping"));
                byte[] buffer = new byte[1024];
                is = new FileInputStream(Util.getAbsoluteFile(ConfigPersister.getInstance().getConfigPath(), c.getJar()));
                os = new FileOutputStream(outfile, true);
                while ((len = is.read(buffer)) > 0) {
                    os.write(buffer, 0, len);
                }
            }
            this._log.append(Messages.getString("Builder.success") + outfile.getPath());
            file = outfile;
        }
        catch (IOException e) {
            try {
                Util.delete(outfile);
                this._log.append(e.getMessage());
                throw new BuilderException(e);
                catch (ExecException e2) {
                    Util.delete(outfile);
                    String msg = e2.getMessage();
                    if (msg == null) throw new BuilderException(e2);
                    if (msg.indexOf("windres") == -1) throw new BuilderException(e2);
                    if (e2.getErrLine() != -1) {
                        this._log.append(Messages.getString("Builder.line.has.errors", String.valueOf(e2.getErrLine())));
                        if (e2.getErrLine() <= 0) throw new BuilderException(e2);
                        this._log.append(rcb.getLine(e2.getErrLine()));
                        throw new BuilderException(e2);
                    }
                    this._log.append(Messages.getString("Builder.generated.resource.file"));
                    this._log.append(rcb.getContent());
                    throw new BuilderException(e2);
                }
            }
            catch (Throwable throwable) {
                Util.close(is);
                Util.close(os);
                Util.delete(rc);
                Util.delete(ro);
                throw throwable;
            }
        }
        Util.close(is);
        Util.close(os);
        Util.delete(rc);
        Util.delete(ro);
        return file;
    }
}

