/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import net.sf.launch4j.ExecException;
import net.sf.launch4j.Log;
import net.sf.launch4j.Util;

class Cmd {
    private final StringBuffer _sb = new StringBuffer();
    private final File _basedir;
    private final File _bindir;
    private final boolean _quote;

    public Cmd(File basedir) {
        File bindir;
        this._basedir = basedir;
        this._quote = basedir.getPath().indexOf(32) != -1;
        String path = System.getProperty("launch4j.bindir");
        this._bindir = path == null ? new File(basedir, "bin") : ((bindir = new File(path)).isAbsolute() ? bindir : new File(basedir, path));
    }

    public Cmd add(String s) {
        this.space();
        this._sb.append(s);
        return this;
    }

    public Cmd addAbsFile(File file) {
        boolean quote;
        this.space();
        boolean bl = quote = file.getPath().indexOf(32) != -1;
        if (quote) {
            this._sb.append('\"');
        }
        this._sb.append(file.getPath());
        if (quote) {
            this._sb.append('\"');
        }
        return this;
    }

    public Cmd addFile(String pathname) {
        this.space();
        if (this._quote) {
            this._sb.append('\"');
        }
        this._sb.append(new File(this._basedir, pathname).getPath());
        if (this._quote) {
            this._sb.append('\"');
        }
        return this;
    }

    public Cmd addExe(String pathname) {
        this.space();
        if (this._quote) {
            this._sb.append('\"');
        }
        if (Util.WINDOWS_OS) {
            pathname = pathname + ".exe";
        }
        this._sb.append(new File(this._bindir, pathname).getPath());
        if (this._quote) {
            this._sb.append('\"');
        }
        return this;
    }

    public Cmd addFiles(List files) {
        Iterator iter = files.iterator();
        while (iter.hasNext()) {
            this.addFile((String)iter.next());
        }
        return this;
    }

    private void space() {
        if (this._sb.length() > 0) {
            this._sb.append(' ');
        }
    }

    public String toString() {
        return this._sb.toString();
    }

    public void exec(Log log) throws ExecException {
        Util.exec(this._sb.toString(), log);
    }
}

