/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j.binding;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.sf.launch4j.Util;
import net.sf.launch4j.binding.InvariantViolationException;
import net.sf.launch4j.binding.Messages;
import net.sf.launch4j.config.ConfigPersister;

public class Validator {
    public static final String ALPHANUMERIC_PATTERN = "[\\w]*?";
    public static final String ALPHA_PATTERN = "[\\w&&\\D]*?";
    public static final String NUMERIC_PATTERN = "[\\d]*?";
    public static final String PATH_PATTERN = "[\\w|[ .,:\\-/\\\\]]*?";
    public static final int MAX_STR = 128;
    public static final int MAX_PATH = 260;
    public static final int MAX_BIG_STR = 8192;
    public static final int MAX_ARGS = 30719;

    private Validator() {
    }

    public static boolean isEmpty(String s) {
        return s == null || s.equals("");
    }

    public static void checkNotNull(Object o, String property, String name) {
        if (o == null) {
            Validator.signalViolation(property, Messages.getString("Validator.empty.field", name));
        }
    }

    public static void checkString(String s, int maxLength, String property, String name) {
        if (s == null || s.length() == 0) {
            Validator.signalViolation(property, Messages.getString("Validator.empty.field", name));
        }
        if (s.length() > maxLength) {
            Validator.signalLengthViolation(property, name, maxLength);
        }
    }

    public static void checkOptStrings(List strings, int maxLength, int totalMaxLength, String property, String name) {
        if (strings == null) {
            return;
        }
        int totalLength = 0;
        for (String s : strings) {
            Validator.checkString(s, maxLength, property, name);
            if ((totalLength += s.length()) <= totalMaxLength) continue;
            Validator.signalLengthViolation(property, name, totalMaxLength);
        }
    }

    public static void checkString(String s, int maxLength, String pattern, String property, String name) {
        Validator.checkString(s, maxLength, property, name);
        if (!s.matches(pattern)) {
            Validator.signalViolation(property, Messages.getString("Validator.invalid.data", name));
        }
    }

    public static void checkOptStrings(List strings, int maxLength, int totalMaxLength, String pattern, String property, String name, String msg) {
        if (strings == null) {
            return;
        }
        int totalLength = 0;
        for (String s : strings) {
            Validator.checkString(s, maxLength, property, name);
            if (!s.matches(pattern)) {
                Validator.signalViolation(property, msg != null ? msg : Messages.getString("Validator.invalid.data", name));
            }
            if ((totalLength += s.length()) <= totalMaxLength) continue;
            Validator.signalLengthViolation(property, name, totalMaxLength);
        }
    }

    public static void checkOptString(String s, int maxLength, String property, String name) {
        if (s == null || s.length() == 0) {
            return;
        }
        if (s.length() > maxLength) {
            Validator.signalLengthViolation(property, name, maxLength);
        }
    }

    public static void checkOptString(String s, int maxLength, String pattern, String property, String name) {
        if (s == null || s.length() == 0) {
            return;
        }
        if (s.length() > maxLength) {
            Validator.signalLengthViolation(property, name, maxLength);
        }
        if (!s.matches(pattern)) {
            Validator.signalViolation(property, Messages.getString("Validator.invalid.data", name));
        }
    }

    public static void checkRange(int value, int min, int max, String property, String name) {
        if (value < min || value > max) {
            Validator.signalViolation(property, Messages.getString("ValidatocheckFiler.must.be.in.range", name, String.valueOf(min), String.valueOf(max)));
        }
    }

    public static void checkRange(char value, char min, char max, String property, String name) {
        if (value < min || value > max) {
            Validator.signalViolation(property, Messages.getString("Validator.must.be.in.range", name, String.valueOf(min), String.valueOf(max)));
        }
    }

    public static void checkMin(int value, int min, String property, String name) {
        if (value < min) {
            Validator.signalViolation(property, Messages.getString("Validator.must.be.at.least", name, String.valueOf(min)));
        }
    }

    public static void checkIn(String s, String[] inList, String property, String name) {
        if (s == null || s.length() == 0) {
            Validator.signalViolation(property, Messages.getString("Validator.empty.field", name));
        }
        for (int i = 0; i < inList.length; ++i) {
            if (!s.equals(inList[i])) continue;
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < inList.length; ++i) {
            sb.append(inList[i]);
            if (i >= inList.length - 1) continue;
            sb.append(", ");
        }
        Validator.signalViolation(property, Messages.getString("Validator.invalid.option", name, sb.toString()));
    }

    public static void checkTrue(boolean condition, String property, String msg) {
        if (!condition) {
            Validator.signalViolation(property, msg);
        }
    }

    public static void checkFalse(boolean condition, String property, String msg) {
        if (condition) {
            Validator.signalViolation(property, msg);
        }
    }

    public static void checkElementsNotNullUnique(Collection c, String property, String msg) {
        if (c.contains(null) || new HashSet(c).size() != c.size()) {
            Validator.signalViolation(property, Messages.getString("Validator.already.exists", msg));
        }
    }

    public static void checkElementsUnique(Collection c, String property, String msg) {
        if (new HashSet(c).size() != c.size()) {
            Validator.signalViolation(property, Messages.getString("Validator.already.exists", msg));
        }
    }

    public static void checkFile(File f, String property, String fileDescription) {
        File cfgPath = ConfigPersister.getInstance().getConfigPath();
        if (f == null || !f.exists() && !Util.getAbsoluteFile(cfgPath, f).exists()) {
            Validator.signalViolation(property, Messages.getString("Validator.doesnt.exist", fileDescription));
        }
    }

    public static void checkOptFile(File f, String property, String fileDescription) {
        if (f != null && f.getPath().length() > 0) {
            Validator.checkFile(f, property, fileDescription);
        }
    }

    public static void checkRelativeWinPath(String path, String property, String msg) {
        if (path == null || path.equals("") || path.startsWith("/") || path.startsWith("\\") || path.indexOf(58) != -1) {
            Validator.signalViolation(property, msg);
        }
    }

    public static void signalLengthViolation(String property, String name, int maxLength) {
        Validator.signalViolation(property, Messages.getString("Validator.exceeds.max.length", name, String.valueOf(maxLength)));
    }

    public static void signalViolation(String property, String msg) {
        throw new InvariantViolationException(property, msg);
    }
}

