/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j.config;

import java.util.List;
import net.sf.launch4j.binding.IValidatable;
import net.sf.launch4j.binding.Validator;
import net.sf.launch4j.config.Messages;

public class Jre
implements IValidatable {
    public static final String PATH = "jrepath";
    public static final String MIN_VERSION = "javamin";
    public static final String MAX_VERSION = "javamax";
    public static final String ARGS = "jvmArgs";
    public static final String VERSION_PATTERN = "(\\d\\.){2}\\d(_\\d+)?";
    private String path;
    private String minVersion;
    private String maxVersion;
    private boolean dontUsePrivateJres;
    private int initialHeapSize;
    private int maxHeapSize;
    private List options;

    public void checkInvariants() {
        Validator.checkOptString(this.minVersion, 10, VERSION_PATTERN, "jre.minVersion", Messages.getString("Jre.min.version"));
        Validator.checkOptString(this.maxVersion, 10, VERSION_PATTERN, "jre.maxVersion", Messages.getString("Jre.max.version"));
        if (Validator.isEmpty(this.path)) {
            Validator.checkFalse(Validator.isEmpty(this.minVersion), "jre.path", Messages.getString("Jre.specify.jre.path.min.version"));
        } else {
            Validator.checkString(this.path, 260, "jre.path", Messages.getString("Jre.embedded.path"));
        }
        if (!Validator.isEmpty(this.maxVersion)) {
            Validator.checkFalse(Validator.isEmpty(this.minVersion), "jre.minVersion", Messages.getString("Jre.specify.min.version"));
            Validator.checkTrue(this.minVersion.compareTo(this.maxVersion) < 0, "jre.maxVersion", Messages.getString("Jre.max.greater.than.min"));
        }
        Validator.checkTrue(this.initialHeapSize >= 0, "jre.initialHeapSize", Messages.getString("Jre.initial.heap"));
        Validator.checkTrue(this.maxHeapSize == 0 || this.initialHeapSize <= this.maxHeapSize, "jre.maxHeapSize", Messages.getString("Jre.max.heap"));
        Validator.checkOptStrings(this.options, 30719, 30719, "[^\"]*|([^\"]*\"[^\"]*\"[^\"]*)*", "jre.options", Messages.getString("Jre.jvm.options"), Messages.getString("Jre.jvm.options.unclosed.quotation"));
        Validator.checkOptStrings(this.options, 30719, 30719, "[^%]*|([^%]*\"([^%]*%[^%]+%[^%]*)+\"[^%]*)*", "jre.options", Messages.getString("Jre.jvm.options"), Messages.getString("Jre.jvm.options.variable"));
    }

    public List getOptions() {
        return this.options;
    }

    public void setOptions(List options) {
        this.options = options;
    }

    public String getMaxVersion() {
        return this.maxVersion;
    }

    public void setMaxVersion(String maxVersion) {
        this.maxVersion = maxVersion;
    }

    public String getMinVersion() {
        return this.minVersion;
    }

    public void setMinVersion(String minVersion) {
        this.minVersion = minVersion;
    }

    public boolean isDontUsePrivateJres() {
        return this.dontUsePrivateJres;
    }

    public void setDontUsePrivateJres(boolean dontUsePrivateJres) {
        this.dontUsePrivateJres = dontUsePrivateJres;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getInitialHeapSize() {
        return this.initialHeapSize;
    }

    public void setInitialHeapSize(int initialHeapSize) {
        this.initialHeapSize = initialHeapSize;
    }

    public int getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public void setMaxHeapSize(int maxHeapSize) {
        this.maxHeapSize = maxHeapSize;
    }
}

