package com.akathist.maven.plugins.launch4j;

import static org.easymock.EasyMock.createMock;
import static org.easymock.EasyMock.expect;
import static org.easymock.EasyMock.replay;

import org.apache.maven.artifact.Artifact;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/**
 *
 * @author Ian Pojman (ian)
 */
public class ClassPathTest
{
    private ClassPath classPath;

    @Before
    public void setup() {
        classPath=new ClassPath();
    }
    
    @Test
    public void test() {
        checkReplace("1.0-ACTUAL", "1.0-SNAPSHOT");
    }

    // see JIRA LAUNCHPLUGIN-9
    @Test 
    public void test_LAUNCHPLUGIN9() {
        // replicate LAUNCHPLUGIN-9,
        // it was replacing 1.0.0-SNAPSHOT with 1.1.0.0-SNAPSHOT
        checkReplace("1.0-ACTUAL", "1.0.0-SNAPSHOT");
    }

    private void checkReplace(String artifactVersion, String pomVersion)
    {
        final Artifact artifact = createFakeArtifact(artifactVersion);
        final String s = classPath.snapshotArtifactFilename(artifact, pomVersion);
        Assert.assertEquals(s,artifactVersion);
    }

    /** Create an artifact with the given version */
    private Artifact createFakeArtifact(String version)
    {
        Artifact mock = createMock(Artifact.class);
        expect(mock.getVersion()).andReturn(version);
        replay(mock);
        return mock;
    }
}
