/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.eoa.system.plugin.release.util;

import java.io.FileWriter;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.bluestemsoftware.open.eoa.system.plugin.release.util.DOMSerializer;
import org.bluestemsoftware.open.eoa.system.plugin.release.util.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class SCMUrlUpdater {
    public static void updateProject(MavenProject project, String toVersion) throws MojoExecutionException {
        Document pom = null;
        try {
            DocumentBuilderFactoryImpl dbf = new DocumentBuilderFactoryImpl();
            dbf.setNamespaceAware(true);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            pom = builder.parse(project.getFile());
        }
        catch (Exception pe) {
            throw new MojoExecutionException("Error parsing pom.", pe);
        }
        boolean modified = false;
        Element projectElement = pom.getDocumentElement();
        Element scmElement = DOMUtils.getChildElement(projectElement, new QName("http://maven.apache.org/POM/4.0.0", "scm"));
        if (scmElement != null) {
            Element ue;
            Element de;
            Element ce = DOMUtils.getChildElement(scmElement, new QName("http://maven.apache.org/POM/4.0.0", "connection"));
            if (ce != null) {
                String url;
                int index;
                Text textNode = (Text)ce.getFirstChild();
                String data = textNode.getData();
                if (toVersion.equals("SNAPSHOT")) {
                    index = data.indexOf("tags");
                    if (index > -1) {
                        url = data.substring(0, index) + "trunk";
                        ce.removeChild(textNode);
                        ce.appendChild(pom.createTextNode(url));
                        modified = true;
                    }
                } else {
                    index = data.indexOf("trunk");
                    if (index > -1) {
                        url = data.substring(0, index) + "tags/" + toVersion;
                        ce.removeChild(textNode);
                        ce.appendChild(pom.createTextNode(url));
                        modified = true;
                    }
                }
            }
            if ((de = DOMUtils.getChildElement(scmElement, new QName("http://maven.apache.org/POM/4.0.0", "developerConnection"))) != null) {
                String url;
                Text textNode = (Text)de.getFirstChild();
                String data = textNode.getData();
                if (toVersion.equals("SNAPSHOT")) {
                    int index = data.indexOf("tags");
                    if (index > -1) {
                        url = data.substring(0, index) + "trunk";
                        de.removeChild(textNode);
                        de.appendChild(pom.createTextNode(url));
                        modified = true;
                    }
                } else {
                    int index = data.indexOf("trunk");
                    if (index > -1) {
                        url = data.substring(0, index) + "tags/" + toVersion;
                        de.removeChild(textNode);
                        de.appendChild(pom.createTextNode(url));
                        modified = true;
                    }
                }
            }
            if ((ue = DOMUtils.getChildElement(scmElement, new QName("http://maven.apache.org/POM/4.0.0", "url"))) != null) {
                Text textNode = (Text)ue.getFirstChild();
                String data = textNode.getData();
                if (toVersion.equals("SNAPSHOT")) {
                    int index = data.indexOf("tags");
                    if (index > -1) {
                        String url = data.substring(0, index) + "trunk";
                        ue.removeChild(textNode);
                        ue.appendChild(pom.createTextNode(url));
                        modified = true;
                    }
                } else {
                    int index = data.indexOf("trunk");
                    if (index > -1) {
                        String url = data.substring(0, index) + "tags/" + toVersion;
                        ue.removeChild(textNode);
                        ue.appendChild(pom.createTextNode(url));
                        modified = true;
                    }
                }
            }
            if (modified) {
                try {
                    FileWriter fileWriter = new FileWriter(project.getFile());
                    fileWriter.write(DOMSerializer.serializeNode(pom));
                    fileWriter.flush();
                    fileWriter.close();
                }
                catch (Exception ie) {
                    throw new MojoExecutionException("Error updating pom.", ie);
                }
            }
        }
    }
}

