/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.system.plugin.release;

import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.bluestemsoftware.open.eoa.system.plugin.release.util.SystemPathUpdater;
import org.bluestemsoftware.open.eoa.system.plugin.release.util.VersionTagUpdater;

/**
 * Prepares a project for release by checking for uncommitted changes, performing an update and
 * updating version from SNAPSHOT to release version.
 * 
 * @aggregator
 * @goal prepare
 */
public class ReleasePrepareMojo extends AbstractMojo {
    
   /**
     * @parameter expression="${reactorProjects}"
     * @required
     * @readonly
     */
    private List<?> reactorProjects;
    
    /*
     * (non-Javadoc)
     * @see org.apache.maven.plugin.AbstractMojo#execute()
     */
    public void execute() throws MojoExecutionException {
        for (Iterator<?> i = reactorProjects.iterator(); i.hasNext();) {
            processProject((MavenProject)i.next());
            
        }
    }
    
    public void processProject(MavenProject project) throws MojoExecutionException {
        
        // retrieve version which we are about to prepare for
        // release
        
        String toVersion = System.getProperty("toVersion");
        if (toVersion == null) {
            throw new MojoExecutionException("System Property 'toVersion' not set.");
        }
        
        VersionTagUpdater.updateProject(project, "SNAPSHOT", toVersion);
        SystemPathUpdater.updateProject(project, "SNAPSHOT", toVersion);
        
    }

}
