/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.eoa.system.plugin.release;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.bluestemsoftware.open.eoa.system.plugin.release.Exclude;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReleaseSnaphsotsMojo
extends AbstractMojo {
    private ArtifactFactory artifactFactory;
    private List<?> reactorProjects;
    private Exclude[] check = new Exclude[0];

    public void execute() throws MojoExecutionException {
        HashSet<String> excludes = new HashSet<String>();
        for (Exclude exclude : this.check) {
            String groupID = exclude.getGroupId();
            String artifactID = exclude.getArtifactId();
            String key = ArtifactUtils.versionlessKey((String)groupID, (String)artifactID);
            excludes.add(key);
        }
        this.getLog().info((CharSequence)"checking projects for snapshot dependencies ...");
        for (MavenProject project : this.reactorProjects) {
            String artifactID;
            String groupID = project.getGroupId();
            String key = ArtifactUtils.versionlessKey((String)groupID, (String)(artifactID = project.getArtifactId()));
            if (excludes.contains(key)) {
                this.getLog().debug((CharSequence)("excluding project " + artifactID + " from snapshot dependency check"));
                continue;
            }
            this.getLog().debug((CharSequence)("checking project " + artifactID + " for snapshot dependencies"));
            this.checkProject(project);
        }
    }

    private void checkProject(MavenProject project) throws MojoExecutionException {
        Map artifactMap = ArtifactUtils.artifactMapByVersionlessId((Collection)project.getArtifacts());
        HashSet<Artifact> snapshotDependencies = new HashSet<Artifact>();
        HashSet<Artifact> snapshotReportDependencies = new HashSet<Artifact>();
        HashSet<Artifact> snapshotExtensionsDependencies = new HashSet<Artifact>();
        HashSet<Artifact> snapshotPluginDependencies = new HashSet<Artifact>();
        if (project.getParentArtifact() != null && ReleaseSnaphsotsMojo.checkArtifact(project.getParentArtifact(), artifactMap)) {
            snapshotDependencies.add(project.getParentArtifact());
        }
        try {
            Set dependencyArtifacts = project.createArtifacts(this.artifactFactory, null, null);
            for (Artifact artifact : dependencyArtifacts) {
                if (!ReleaseSnaphsotsMojo.checkArtifact(artifact, artifactMap)) continue;
                snapshotDependencies.add(artifact);
            }
        }
        catch (InvalidDependencyVersionException e) {
            throw new MojoExecutionException("Failed to create dependency artifacts", (Exception)((Object)e));
        }
        for (Artifact artifact : project.getPluginArtifacts()) {
            if (!ReleaseSnaphsotsMojo.checkArtifact(artifact, artifactMap)) continue;
            snapshotPluginDependencies.add(artifact);
        }
        for (Artifact artifact : project.getReportArtifacts()) {
            if (!ReleaseSnaphsotsMojo.checkArtifact(artifact, artifactMap)) continue;
            snapshotReportDependencies.add(artifact);
        }
        for (Artifact artifact : project.getExtensionArtifacts()) {
            if (!ReleaseSnaphsotsMojo.checkArtifact(artifact, artifactMap)) continue;
            snapshotExtensionsDependencies.add(artifact);
        }
        if (!(snapshotDependencies.isEmpty() && snapshotReportDependencies.isEmpty() && snapshotExtensionsDependencies.isEmpty() && snapshotPluginDependencies.isEmpty() || snapshotDependencies.isEmpty() && snapshotReportDependencies.isEmpty() && snapshotExtensionsDependencies.isEmpty() && snapshotPluginDependencies.isEmpty())) {
            StringBuffer message = new StringBuffer();
            this.printSnapshotDependencies(snapshotDependencies, message);
            this.printSnapshotDependencies(snapshotReportDependencies, message);
            this.printSnapshotDependencies(snapshotExtensionsDependencies, message);
            this.printSnapshotDependencies(snapshotPluginDependencies, message);
            message.append("in project '" + project.getName() + "' (" + project.getId() + ")");
            throw new MojoExecutionException("Can't release project due to snapshot dependencies:" + System.getProperty("line.separator") + message);
        }
    }

    private static boolean checkArtifact(Artifact artifact, Map<?, ?> artifactMapByVersionlessId) {
        String versionlessId = ArtifactUtils.versionlessKey((Artifact)artifact);
        Artifact temp = (Artifact)artifactMapByVersionlessId.get(versionlessId);
        if (temp == null) {
            return artifact.isSnapshot();
        }
        return temp.isSnapshot();
    }

    private StringBuffer printSnapshotDependencies(Set<Artifact> snapshotsSet, StringBuffer message) {
        ArrayList<Artifact> snapshotsList = new ArrayList<Artifact>(snapshotsSet);
        Collections.sort(snapshotsList);
        for (Artifact artifact : snapshotsList) {
            message.append("    ");
            message.append(artifact);
            message.append(System.getProperty("line.separator"));
        }
        return message;
    }
}

