/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.eoa.system.plugin.release;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.bluestemsoftware.open.eoa.system.plugin.release.util.SCM;
import org.bluestemsoftware.open.eoa.system.plugin.release.util.SCMUrlUpdater;

public class ReleaseTagMojo
extends AbstractMojo {
    private static final String LINE_BREAK = System.getProperty("line.separator");
    private MavenProject project;
    private String tag;
    private List<?> reactorProjects;

    public void execute() throws MojoExecutionException {
        Iterator<?> i = this.reactorProjects.iterator();
        while (i.hasNext()) {
            this.processProject((MavenProject)i.next());
        }
    }

    private void processProject(MavenProject project) throws MojoExecutionException {
        boolean issueCommand = false;
        boolean isWorkingCopyRoot = false;
        if (project.getPackaging().equals("pom")) {
            if (project.getArtifactId().equals("eoa-parent")) {
                issueCommand = true;
            }
            if (project.getArtifactId().endsWith("-trunk")) {
                issueCommand = true;
            }
            if (project.getArtifactId().endsWith("-trunks")) {
                issueCommand = true;
                isWorkingCopyRoot = true;
            }
        }
        if (issueCommand) {
            if (isWorkingCopyRoot) {
                SCM.externals(project, this.getLog(), this.getExternalsFile(this.tag));
            }
            SCMUrlUpdater.updateProject(project, this.tag);
            SCM.tag(project, this.getLog(), this.tag);
            SCMUrlUpdater.updateProject(project, "SNAPSHOT");
            if (isWorkingCopyRoot) {
                SCM.externals(project, this.getLog(), this.getExternalsFile("SNAPSHOT"));
            }
        }
    }

    private String getExternalsFile(String toVersion) throws MojoExecutionException {
        if (toVersion.equals("SNAPSHOT")) {
            return ".svnexternals";
        }
        File externals = null;
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            FileInputStream in = new FileInputStream(new File(this.project.getBasedir(), ".svnexternals"));
            reader = new BufferedReader(new InputStreamReader(in));
            externals = File.createTempFile("svnexternals-", ".tmp");
            FileOutputStream out = new FileOutputStream(externals);
            writer = new BufferedWriter(new OutputStreamWriter(out));
            String text = reader.readLine();
            while (text != null) {
                int index = text.indexOf("trunk");
                if (index > -1) {
                    String url = text.substring(0, index) + "tags/" + toVersion;
                    writer.write(url, 0, url.length());
                    writer.write(LINE_BREAK, 0, LINE_BREAK.length());
                }
                text = reader.readLine();
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error parsing .svnexternals.", ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ignore) {}
            }
            if (writer != null) {
                try {
                    writer.flush();
                    writer.close();
                }
                catch (IOException ignore) {}
            }
        }
        return externals.getAbsolutePath();
    }
}

