/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.eoa.system.plugin.release.util;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.log.DefaultLog;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.manager.BasicScmManager;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnexe.SvnExeScmProvider;
import org.apache.maven.scm.provider.svn.svnexe.command.SvnCommandLineUtils;
import org.apache.maven.scm.repository.ScmRepository;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCM {
    private static final ScmManager scmManager = new BasicScmManager();

    public static void status(MavenProject project, Log log, Set<String> ignore) throws MojoExecutionException {
        ScmRepository repo;
        Scm metadata = project.getModel().getScm();
        scmManager.setScmProvider("svn", (ScmProvider)new SvnExeScmProvider());
        try {
            repo = scmManager.makeScmRepository(metadata.getConnection());
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Unable to create scm connection for project " + project.getArtifactId() + ". " + ex);
        }
        log.info((CharSequence)"checking for modifications ...");
        try {
            StatusScmResult result = scmManager.status(repo, new ScmFileSet(project.getBasedir()));
            SCM.checkResult(project, (ScmResult)result);
            List changedFiles = result.getChangedFiles();
            StringBuilder message = new StringBuilder();
            for (ScmFile file : changedFiles) {
                String name = new File(file.getPath()).getName();
                if (ignore.contains(name)) continue;
                message.append(file.toString());
                message.append(System.getProperty("line.separator"));
            }
            if (message.length() > 0) {
                throw new MojoExecutionException("Project has uncommitted changes in the following files: " + System.getProperty("line.separator") + message);
            }
        }
        catch (ScmException se) {
            throw new MojoExecutionException("Unable to check scm status for project " + project.getArtifactId() + ". " + (Object)((Object)se));
        }
    }

    public static void update(MavenProject project, Log log) throws MojoExecutionException {
        ScmRepository repo;
        Scm metadata = project.getModel().getScm();
        SvnExeScmProvider scmProvider = new SvnExeScmProvider();
        scmProvider.addListener((ScmLogger)new DefaultLog());
        scmManager.setScmProvider("svn", (ScmProvider)scmProvider);
        try {
            repo = scmManager.makeScmRepository(metadata.getConnection());
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Unable to create scm connection for project " + project.getArtifactId() + ". " + ex);
        }
        log.info((CharSequence)"updating project ...");
        try {
            UpdateScmResult result = scmManager.update(repo, new ScmFileSet(project.getBasedir()));
            SCM.checkResult(project, (ScmResult)result);
            List updatedFiles = result.getUpdatedFiles();
            if (updatedFiles.size() > 0) {
                StringBuilder message = new StringBuilder();
                for (ScmFile file : updatedFiles) {
                    message.append(file.toString());
                    message.append(System.getProperty("line.separator"));
                }
                log.info((CharSequence)("updated the following files:" + System.getProperty("line.separator") + message));
            }
        }
        catch (ScmException se) {
            throw new MojoExecutionException("Unable to perform scm update for project " + project.getArtifactId() + ". " + (Object)((Object)se));
        }
    }

    public static void commit(MavenProject project, Log log, String comment) throws MojoExecutionException {
        ScmRepository repo;
        Scm metadata = project.getModel().getScm();
        SvnExeScmProvider scmProvider = new SvnExeScmProvider();
        scmProvider.addListener((ScmLogger)new DefaultLog());
        scmManager.setScmProvider("svn", (ScmProvider)scmProvider);
        try {
            repo = scmManager.makeScmRepository(metadata.getConnection());
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Unable to create scm connection for project " + project.getArtifactId() + ". " + ex);
        }
        log.info((CharSequence)"committing changes ...");
        try {
            CheckInScmResult result = scmManager.checkIn(repo, new ScmFileSet(project.getBasedir()), comment);
            SCM.checkResult(project, (ScmResult)result);
            List updatedFiles = result.getCheckedInFiles();
            if (updatedFiles.size() > 0) {
                StringBuilder message = new StringBuilder();
                for (ScmFile file : updatedFiles) {
                    message.append(file.toString());
                    message.append(System.getProperty("line.separator"));
                }
                log.info((CharSequence)("committed the following files:" + System.getProperty("line.separator") + message));
            }
        }
        catch (ScmException se) {
            throw new MojoExecutionException("Unable to perform scm commit for project " + project.getArtifactId() + ". " + (Object)((Object)se));
        }
    }

    public static void revert(MavenProject project, Log log) throws MojoExecutionException {
        SvnExeScmProvider scmProvider = new SvnExeScmProvider();
        scmProvider.addListener((ScmLogger)new DefaultLog());
        scmManager.setScmProvider("svn", (ScmProvider)scmProvider);
        ScmFileSet fileset = new ScmFileSet(project.getBasedir());
        log.info((CharSequence)"reverting changes ...");
        try {
            Commandline cl = new Commandline();
            cl.setExecutable("svn");
            cl.setWorkingDirectory(fileset.getBasedir());
            cl.createArg().setValue("revert");
            cl.createArg().setValue("--recursive");
            cl.createArg().setValue(".");
            SvnCommandLineUtils.addTarget((Commandline)cl, (List)fileset.getFileList());
            StreamConsumer consumer = new StreamConsumer(){

                public void consumeLine(String line) {
                    System.out.println(line);
                }
            };
            CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
            log.info((CharSequence)("Executing: " + SvnCommandLineUtils.cryptPassword((Commandline)cl)));
            log.info((CharSequence)("Working directory: " + cl.getWorkingDirectory().getAbsolutePath()));
            SvnCommandLineUtils.execute((Commandline)cl, (StreamConsumer)consumer, (CommandLineUtils.StringStreamConsumer)stderr, (ScmLogger)new DefaultLog());
        }
        catch (Exception se) {
            throw new MojoExecutionException("Unable to perform scm revert for project " + project.getArtifactId() + ". " + se);
        }
    }

    public static void tag(MavenProject project, Log log, String tag) throws MojoExecutionException {
        ScmRepository repo;
        Scm metadata = project.getModel().getScm();
        SvnExeScmProvider scmProvider = new SvnExeScmProvider();
        scmProvider.addListener((ScmLogger)new DefaultLog());
        scmManager.setScmProvider("svn", (ScmProvider)scmProvider);
        try {
            repo = scmManager.makeScmRepository(metadata.getConnection());
            if (project.getName().equals("alakai-standalone-trunks")) {
                SvnScmProviderRepository svnRepo = (SvnScmProviderRepository)repo.getProviderRepository();
                svnRepo.setTagBase("svn://alakai.org/eoa/alakai/standalone/tags");
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Unable to create scm connection for project " + project.getArtifactId() + ". " + ex);
        }
        log.info((CharSequence)"tagging project ...");
        try {
            TagScmResult result = scmManager.tag(repo, new ScmFileSet(project.getBasedir()), tag);
            SCM.checkResult(project, (ScmResult)result);
            List copiedFiles = result.getTaggedFiles();
            log.info((CharSequence)("copied " + copiedFiles.size() + " files to tag " + tag));
        }
        catch (ScmException se) {
            throw new MojoExecutionException("Unable to perform scm tag for project " + project.getArtifactId() + ". " + (Object)((Object)se));
        }
    }

    public static void externals(MavenProject project, Log log, String file) throws MojoExecutionException {
        Commandline cl;
        SvnScmProviderRepository svnRepo;
        Scm metadata = project.getModel().getScm();
        SvnExeScmProvider scmProvider = new SvnExeScmProvider();
        scmProvider.addListener((ScmLogger)new DefaultLog());
        scmManager.setScmProvider("svn", (ScmProvider)scmProvider);
        ScmFileSet fileset = new ScmFileSet(project.getBasedir());
        try {
            ScmRepository repo = scmManager.makeScmRepository(metadata.getConnection());
            svnRepo = (SvnScmProviderRepository)repo.getProviderRepository();
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Unable to create scm connection for project " + project.getArtifactId() + ". " + ex);
        }
        if (file != null) {
            log.info((CharSequence)"setting externals prop ...");
            try {
                cl = SvnCommandLineUtils.getBaseSvnCommandLine((File)fileset.getBasedir(), (SvnScmProviderRepository)svnRepo);
                cl.createArg().setValue("propset");
                cl.createArg().setValue("svn:externals");
                cl.createArg().setValue(".");
                cl.createArg().setValue("--file");
                cl.createArg().setValue(file);
                SvnCommandLineUtils.addTarget((Commandline)cl, (List)fileset.getFileList());
                StreamConsumer consumer = new StreamConsumer(){

                    public void consumeLine(String line) {
                        System.out.println(line);
                    }
                };
                CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
                log.info((CharSequence)("Executing: " + SvnCommandLineUtils.cryptPassword((Commandline)cl)));
                log.info((CharSequence)("Working directory: " + cl.getWorkingDirectory().getAbsolutePath()));
                SvnCommandLineUtils.execute((Commandline)cl, (StreamConsumer)consumer, (CommandLineUtils.StringStreamConsumer)stderr, (ScmLogger)new DefaultLog());
            }
            catch (Exception se) {
                throw new MojoExecutionException("Unable to perform scm tag for project " + project.getArtifactId() + ". " + se);
            }
        }
        log.info((CharSequence)"deleting externals prop ...");
        try {
            cl = SvnCommandLineUtils.getBaseSvnCommandLine((File)fileset.getBasedir(), (SvnScmProviderRepository)svnRepo);
            cl.createArg().setValue("propdel");
            cl.createArg().setValue("svn:externals");
            SvnCommandLineUtils.addTarget((Commandline)cl, (List)fileset.getFileList());
            StreamConsumer consumer = new StreamConsumer(){

                public void consumeLine(String line) {
                    System.out.println(line);
                }
            };
            CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
            log.info((CharSequence)("Executing: " + SvnCommandLineUtils.cryptPassword((Commandline)cl)));
            log.info((CharSequence)("Working directory: " + cl.getWorkingDirectory().getAbsolutePath()));
            SvnCommandLineUtils.execute((Commandline)cl, (StreamConsumer)consumer, (CommandLineUtils.StringStreamConsumer)stderr, (ScmLogger)new DefaultLog());
        }
        catch (Exception se) {
            throw new MojoExecutionException("Unable to perform scm tag for project " + project.getArtifactId() + ". " + se);
        }
    }

    private static void checkResult(MavenProject project, ScmResult result) throws MojoExecutionException {
        if (!result.isSuccess()) {
            String message = "Provider message:";
            message = message + System.getProperty("line.separator");
            message = result.getProviderMessage() == null ? message + "" : message + result.getProviderMessage();
            message = message + System.getProperty("line.separator");
            message = message + "Command output:";
            message = message + System.getProperty("line.separator");
            message = result.getCommandOutput() == null ? message + "" : message + result.getCommandOutput();
            throw new MojoExecutionException("Failed updating project " + project.getArtifactId() + ". " + message);
        }
    }
}

