/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.eoa.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.booter.output.FileOutputConsumerProxy;
import org.apache.maven.surefire.booter.output.ForkingStreamConsumer;
import org.apache.maven.surefire.booter.output.OutputConsumer;
import org.apache.maven.surefire.booter.output.StandardOutputConsumer;
import org.apache.maven.surefire.report.ConsoleReporter;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurefireBooter {
    static final String LINE_BREAK = System.getProperty("line.separator");
    private String groupID;
    private String artifactID;
    private String packaging;
    private String version;
    private List<Object[]> testSuites;
    private List<Object[]> reports = new ArrayList<Object[]>();
    private Set<String> parentClasspath;
    private Set<String> sharedClasspath;
    private Set<String> deploymentClasspath;
    private Set<String> clientClasspath;
    private Set<String> surefireBooterClasspath;
    private Set<String> surefireClasspath;
    private File reportsDirectory;
    private String basedir;
    private String testClassesDirectory;
    private String workingDirectory;
    private boolean redirectTestOutputToFile;
    private boolean isIntegrationTest;
    private boolean isClientTest;
    private static String DEBUG = "-Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=5005";
    private static String SYSTEM_PROPERTY_PREFIX = "_system.";

    public SurefireBooter() {
        this.testSuites = new ArrayList<Object[]>();
    }

    public void addReport(String report, Object[] constructorParams) {
        this.reports.add(new Object[]{report, constructorParams});
    }

    public void addTestSuite(String suiteClassName, Object[] constructorParams) {
        this.testSuites.add(new Object[]{suiteClassName, constructorParams});
    }

    public void setDeploymentClasspath(Set<String> deploymentClasspath) {
        this.deploymentClasspath = deploymentClasspath;
    }

    public void setClientClasspath(Set<String> clientClasspath) {
        this.clientClasspath = clientClasspath;
    }

    public void setParentClasspath(Set<String> parentClasspath) {
        this.parentClasspath = parentClasspath;
    }

    public void setSharedClasspath(Set<String> sharedClasspath) {
        this.sharedClasspath = sharedClasspath;
    }

    public void setSurefireBooterClasspath(Set<String> surefireBooterClasspath) {
        this.surefireBooterClasspath = surefireBooterClasspath;
    }

    public void setSurefireClasspath(Set<String> surefireClasspath) {
        this.surefireClasspath = surefireClasspath;
    }

    public void setRedirectTestOutputToFile(boolean redirectTestOutputToFile) {
        this.redirectTestOutputToFile = redirectTestOutputToFile;
    }

    public void setReportsDirectory(File reportsDirectory) {
        this.reportsDirectory = reportsDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void setArtifactID(String artifactID) {
        this.artifactID = artifactID;
    }

    public void setIntegrationTest(boolean isIntegrationTest) {
        this.isIntegrationTest = isIntegrationTest;
    }

    public void setGroupID(String groupID) {
        this.groupID = groupID;
    }

    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setTestClassesDirectory(String testClassesDirectory) {
        this.testClassesDirectory = testClassesDirectory;
    }

    public void setBasedir(String basedir) {
        this.basedir = basedir;
    }

    public void setClientTest(boolean isClientTest) {
        this.isClientTest = isClientTest;
    }

    public boolean run() throws Exception {
        Commandline cli = new Commandline();
        cli.setExecutable(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java");
        if (this.isIntegrationTest) {
            if (this.isClientTest) {
                if (System.getProperty("maven.surefire.it.client.debug") != null) {
                    cli.createArg().setLine(DEBUG);
                }
            } else if (System.getProperty("maven.surefire.it.debug") != null) {
                cli.createArg().setLine(DEBUG);
            }
        } else if (System.getProperty("maven.surefire.debug") != null) {
            cli.createArg().setLine(DEBUG);
        }
        cli.createArg().setValue("-classpath");
        cli.createArg().setValue(StringUtils.join(this.surefireBooterClasspath.iterator(), (String)File.pathSeparator));
        cli.createArg().setValue(SurefireBooter.class.getName());
        cli.setWorkingDirectory(this.workingDirectory);
        cli.createArg().setFile(this.writePropertiesFile());
        StreamConsumer out = this.getForkingStreamConsumer();
        StreamConsumer err = this.getForkingStreamConsumer();
        int exitCode = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)out, (StreamConsumer)err);
        return exitCode == 0;
    }

    boolean runSurefire() throws SurefireExecutionException {
        boolean success = true;
        ClassLoader testsClassloader = null;
        ClassLoader surefireClassLoader = null;
        try {
            ClassLoader pcl = this.getParentClassLoader();
            if (this.isClientTest) {
                testsClassloader = this.getClientClassLoader();
            } else {
                ClassLoader scl = this.getSharedClassLoader(pcl);
                testsClassloader = this.getDeploymentClassLoader(pcl, scl);
            }
        }
        catch (Exception ex) {
            throw new SurefireExecutionException(ex.getMessage(), (Throwable)ex);
        }
        System.setProperty("eoa.system.dut.groupid", this.groupID);
        System.setProperty("eoa.system.dut.artifactid", this.artifactID);
        System.setProperty("eoa.system.dut.packaging", this.packaging);
        System.setProperty("eoa.system.dut.version", this.version);
        System.setProperty("basedir", this.basedir);
        System.setProperty("testClassesDirectory", this.testClassesDirectory);
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        Object configuration = null;
        if (this.isIntegrationTest) {
            if (this.isClientTest) {
                System.out.println(LINE_BREAK + "running client configuration ...");
            } else {
                System.out.println(LINE_BREAK + "running system configuration ...");
            }
            Class<?> configurationClass = null;
            try {
                configuration = this.getConfiguration(testsClassloader);
                configurationClass = configuration.getClass();
                Method setUp = configurationClass.getMethod("setUp", new Class[0]);
                Thread.currentThread().setContextClassLoader(testsClassloader);
                success = (Boolean)setUp.invoke(configuration, new Object[0]);
            }
            catch (Exception ex) {
                if (ex.getMessage() == null) {
                    throw new SurefireExecutionException("Error executing configuration.", (Throwable)ex);
                }
                throw new SurefireExecutionException("Error executing configuration. " + ex.getMessage(), (Throwable)ex);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
            if (!this.isClientTest) {
                Class<?> tmp = null;
                try {
                    tmp = testsClassloader.loadClass("org.bluestemsoftware.open.eoa.test.system.cfg.ApplicationConfiguration");
                }
                catch (ClassNotFoundException ce) {
                    throw new SurefireExecutionException("Error executing configuration. " + ce.getMessage(), (Throwable)ce);
                }
                if (tmp.isAssignableFrom(configurationClass)) {
                    Map testProperties;
                    HashMap proles;
                    try {
                        Method method = tmp.getMethod("getMockPartnerRoles", new Class[0]);
                        Thread.currentThread().setContextClassLoader(testsClassloader);
                        proles = method.invoke(configuration, new Object[0]);
                    }
                    catch (Exception ex) {
                        if (ex.getMessage() == null) {
                            throw new SurefireExecutionException("Error executing configuration.", (Throwable)ex);
                        }
                        throw new SurefireExecutionException("Error executing configuration. " + ex.getMessage(), (Throwable)ex);
                    }
                    if (proles == null) {
                        proles = new HashMap();
                    }
                    if ((testProperties = (Map)System.getProperties().get("eoa.system.test.properties")) == null) {
                        throw new SurefireExecutionException("Error executing configuration. ApplicationConfiguration instance  failed to define test properties map as system property", null);
                    }
                    testProperties.put("mock.partner.roles", proles);
                }
            }
        }
        if (!success) {
            System.out.println(LINE_BREAK + "error setting up configuration. see alakai.log for details");
            return success;
        }
        if (this.isIntegrationTest) {
            if (this.isClientTest) {
                System.out.println(LINE_BREAK + "executing client tests");
            } else {
                System.out.println(LINE_BREAK + "executing system tests");
            }
        } else {
            System.out.println(LINE_BREAK + "executing unit tests");
        }
        try {
            String className = "org.apache.maven.surefire.Surefire";
            surefireClassLoader = this.getSurefireClassLoader(testsClassloader);
            Class<?> surefireClass = surefireClassLoader.loadClass(className);
            Class[] signature = new Class[]{List.class, List.class, ClassLoader.class, ClassLoader.class};
            Method run = surefireClass.getMethod("run", signature);
            Thread.currentThread().setContextClassLoader(testsClassloader);
            Object[] args = new Object[]{this.reports, this.testSuites, surefireClassLoader, testsClassloader};
            success = (Boolean)run.invoke(surefireClass.newInstance(), args);
        }
        catch (Exception ex) {
            if (ex.getMessage() == null) {
                throw new SurefireExecutionException("Error executing tests.", (Throwable)ex);
            }
            throw new SurefireExecutionException("Error executing tests. " + ex.getMessage(), (Throwable)ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
        if (!this.isIntegrationTest || !success) {
            return success;
        }
        String clientTestClassesDirectory = this.getClientTestClassesDirectory();
        if (clientTestClassesDirectory != null) {
            boolean temp;
            SurefireBooter surefireBooter = new SurefireBooter();
            surefireBooter.setClientTest(true);
            surefireBooter.setIntegrationTest(true);
            surefireBooter.setGroupID(this.groupID);
            surefireBooter.setArtifactID(this.artifactID);
            surefireBooter.setPackaging(this.packaging);
            surefireBooter.setVersion(this.version);
            surefireBooter.setTestClassesDirectory(clientTestClassesDirectory);
            surefireBooter.setRedirectTestOutputToFile(this.redirectTestOutputToFile);
            surefireBooter.setReportsDirectory(this.getClientTestReportsDirectory());
            surefireBooter.setParentClasspath(this.parentClasspath);
            surefireBooter.setSharedClasspath(this.sharedClasspath);
            surefireBooter.setDeploymentClasspath(this.deploymentClasspath);
            surefireBooter.setClientClasspath(this.clientClasspath);
            surefireBooter.setSurefireBooterClasspath(this.surefireBooterClasspath);
            surefireBooter.setSurefireClasspath(this.surefireClasspath);
            surefireBooter.setBasedir(this.basedir);
            surefireBooter.setWorkingDirectory(this.getClientWorkingDirectory());
            this.addClientTestSuiteDefinitions(surefireBooter);
            this.addClientReportDefinitions(surefireBooter);
            try {
                temp = surefireBooter.run();
            }
            catch (Exception ex) {
                if (ex.getMessage() == null) {
                    throw new SurefireExecutionException("Error executing client tests.", (Throwable)ex);
                }
                throw new SurefireExecutionException("Error executing client tests. " + ex.getMessage(), (Throwable)ex);
            }
            success = success && temp;
        } else if (this.isIntegrationTest && !this.isClientTest) {
            System.out.println(LINE_BREAK + "no client tests to execute" + LINE_BREAK);
        }
        if (configuration != null) {
            if (this.isClientTest) {
                System.out.println(LINE_BREAK + "cleaning up client configuration");
            } else {
                System.out.println(LINE_BREAK + "cleaning up system configuration");
            }
            boolean temp = false;
            try {
                Class<?> configurationClass = configuration.getClass();
                Method destroy = configurationClass.getMethod("destroy", new Class[0]);
                Thread.currentThread().setContextClassLoader(testsClassloader);
                temp = (Boolean)destroy.invoke(configuration, new Object[0]);
            }
            catch (Exception ex) {
                if (ex.getMessage() == null) {
                    throw new SurefireExecutionException("Error destroying configuration.", (Throwable)ex);
                }
                throw new SurefireExecutionException("Error destroying configuration. " + ex.getMessage(), (Throwable)ex);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
            if (!temp) {
                System.out.println(LINE_BREAK + "error cleaning up configuration. see log for details");
            }
            success = temp && success;
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File writePropertiesFile() throws Exception {
        Properties properties = new Properties();
        for (String key : System.getProperties().stringPropertyNames()) {
            properties.put(SYSTEM_PROPERTY_PREFIX + key, System.getProperty(key));
        }
        properties.setProperty("groupID", this.groupID);
        properties.setProperty("artifactID", this.artifactID);
        properties.setProperty("packaging", this.packaging);
        properties.setProperty("version", this.version);
        properties.setProperty("basedir", this.basedir);
        properties.setProperty("testClassesDirectory", this.testClassesDirectory);
        properties.setProperty("redirectTestOutputToFile", Boolean.toString(this.redirectTestOutputToFile));
        properties.setProperty("reportsDirectory", this.reportsDirectory.getAbsolutePath());
        properties.setProperty("workingDirectory", this.workingDirectory);
        properties.setProperty("isIntegrationTest", Boolean.toString(this.isIntegrationTest));
        properties.setProperty("isClientTest", Boolean.toString(this.isClientTest));
        String debugProperty = this.getDebugProperty();
        if (debugProperty != null) {
            properties.setProperty("debugProperty", debugProperty);
        }
        this.addPropertiesForTypeHolder(this.reports, properties, "report.");
        this.addPropertiesForTypeHolder(this.testSuites, properties, "testSuite.");
        int a = 0;
        for (String url : this.parentClasspath) {
            properties.setProperty("parentClasspathURL." + a++, url);
        }
        int b = 0;
        for (String url : this.sharedClasspath) {
            properties.setProperty("sharedClasspathURL." + b++, url);
        }
        int c = 0;
        for (String url : this.deploymentClasspath) {
            properties.setProperty("deploymentClasspathURL." + c++, url);
        }
        int d = 0;
        for (String url : this.clientClasspath) {
            properties.setProperty("clientClasspathURL." + d++, url);
        }
        int e = 0;
        for (String url : this.surefireClasspath) {
            properties.setProperty("surefireClasspathURL." + e++, url);
        }
        int f = 0;
        for (String url : this.surefireBooterClasspath) {
            properties.setProperty("surefireBooterClasspathURL." + f++, url);
        }
        File propertiesFile = File.createTempFile("surefire-", ".tmp");
        propertiesFile.deleteOnExit();
        FileOutputStream out = new FileOutputStream(propertiesFile);
        try {
            properties.store(out, "surefire");
        }
        finally {
            IOUtil.close((OutputStream)out);
        }
        return propertiesFile;
    }

    private void addPropertiesForTypeHolder(List<Object[]> typeHolderList, Properties properties, String propertyPrefix) {
        for (int i = 0; i < typeHolderList.size(); ++i) {
            Object[] definition = typeHolderList.get(i);
            String className = (String)definition[0];
            Object[] params = (Object[])definition[1];
            properties.setProperty(propertyPrefix + i, className);
            if (params == null) continue;
            String paramProperty = params[0].toString();
            String typeProperty = params[0].getClass().getName();
            for (int j = 1; j < params.length; ++j) {
                paramProperty = paramProperty + "|";
                typeProperty = typeProperty + "|";
                if (params[j] == null) continue;
                paramProperty = paramProperty + params[j].toString();
                typeProperty = typeProperty + params[j].getClass().getName();
            }
            properties.setProperty(propertyPrefix + i + ".params", paramProperty);
            properties.setProperty(propertyPrefix + i + ".types", typeProperty);
        }
    }

    private StreamConsumer getForkingStreamConsumer() {
        if (this.redirectTestOutputToFile) {
            FileOutputConsumerProxy proxy = null;
            proxy = new FileOutputConsumerProxy((OutputConsumer)new StandardOutputConsumer(), this.reportsDirectory);
            return new ForkingStreamConsumer((OutputConsumer)proxy);
        }
        return new ForkingStreamConsumer((OutputConsumer)new StandardOutputConsumer());
    }

    public static void main(String[] args) {
        try {
            boolean success;
            String name;
            Properties p = SurefireBooter.loadProperties(new File(args[0]));
            SurefireBooter sb = new SurefireBooter();
            sb.groupID = p.getProperty("groupID");
            sb.artifactID = p.getProperty("artifactID");
            sb.packaging = p.getProperty("packaging");
            sb.version = p.getProperty("version");
            sb.basedir = p.getProperty("basedir");
            sb.testClassesDirectory = p.getProperty("testClassesDirectory");
            sb.redirectTestOutputToFile = Boolean.parseBoolean(p.getProperty("redirectTestOutputToFile"));
            sb.reportsDirectory = new File(p.getProperty("reportsDirectory"));
            sb.workingDirectory = p.getProperty("workingDirectory");
            sb.isIntegrationTest = Boolean.parseBoolean(p.getProperty("isIntegrationTest"));
            sb.isClientTest = Boolean.parseBoolean(p.getProperty("isClientTest"));
            sb.parentClasspath = new HashSet<String>();
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                name = (String)e.nextElement();
                if (!name.startsWith("parentClasspathURL.")) continue;
                sb.parentClasspath.add(p.getProperty(name));
            }
            sb.sharedClasspath = new HashSet<String>();
            e = p.propertyNames();
            while (e.hasMoreElements()) {
                name = (String)e.nextElement();
                if (!name.startsWith("sharedClasspathURL.")) continue;
                sb.sharedClasspath.add(p.getProperty(name));
            }
            sb.surefireClasspath = new HashSet<String>();
            e = p.propertyNames();
            while (e.hasMoreElements()) {
                name = (String)e.nextElement();
                if (!name.startsWith("surefireClasspathURL.")) continue;
                sb.surefireClasspath.add(p.getProperty(name));
            }
            sb.surefireBooterClasspath = new HashSet<String>();
            e = p.propertyNames();
            while (e.hasMoreElements()) {
                name = (String)e.nextElement();
                if (!name.startsWith("surefireBooterClasspathURL.")) continue;
                sb.surefireBooterClasspath.add(p.getProperty(name));
            }
            sb.deploymentClasspath = new HashSet<String>();
            e = p.propertyNames();
            while (e.hasMoreElements()) {
                name = (String)e.nextElement();
                if (!name.startsWith("deploymentClasspathURL.")) continue;
                sb.deploymentClasspath.add(p.getProperty(name));
            }
            sb.clientClasspath = new HashSet<String>();
            e = p.propertyNames();
            while (e.hasMoreElements()) {
                name = (String)e.nextElement();
                if (!name.startsWith("clientClasspathURL.")) continue;
                sb.clientClasspath.add(p.getProperty(name));
            }
            e = p.propertyNames();
            while (e.hasMoreElements()) {
                String types;
                String params;
                String className;
                name = (String)e.nextElement();
                if (name.startsWith("report.") && !name.endsWith(".params") && !name.endsWith(".types")) {
                    className = p.getProperty(name);
                    params = p.getProperty(name + ".params");
                    types = p.getProperty(name + ".types");
                    sb.addReport(className, SurefireBooter.constructParamObjects(params, types));
                    continue;
                }
                if (!name.startsWith("testSuite.") || name.endsWith(".params") || name.endsWith(".types")) continue;
                className = p.getProperty(name);
                params = p.getProperty(name + ".params");
                types = p.getProperty(name + ".types");
                sb.addTestSuite(className, SurefireBooter.constructParamObjects(params, types));
            }
            String debugProperty = p.getProperty("debugProperty");
            if (debugProperty != null) {
                System.setProperty(debugProperty, "");
            }
            System.exit((success = sb.runSurefire()) ? 0 : 1);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(File file) throws IOException {
        Properties p = new Properties();
        if (file != null && file.exists()) {
            FileInputStream inStream = new FileInputStream(file);
            try {
                p.load(inStream);
            }
            finally {
                IOUtil.close((InputStream)inStream);
            }
        }
        for (String key : p.stringPropertyNames()) {
            if (!key.startsWith(SYSTEM_PROPERTY_PREFIX)) continue;
            String value = p.getProperty(key);
            p.remove(key);
            if (System.getProperty(key = key.substring(SYSTEM_PROPERTY_PREFIX.length())) != null) continue;
            System.setProperty(key, value);
        }
        return p;
    }

    private static Object[] constructParamObjects(String paramProperty, String typeProperty) {
        Object[] paramObjects = null;
        if (paramProperty != null) {
            String[] params = StringUtils.split((String)StringUtils.replace((String)StringUtils.replace((String)paramProperty, (String)"||", (String)"| |"), (String)"||", (String)"| |"), (String)"|");
            String[] types = StringUtils.split((String)StringUtils.replace((String)StringUtils.replace((String)typeProperty, (String)"||", (String)"| |"), (String)"||", (String)"| |"), (String)"|");
            paramObjects = new Object[params.length];
            for (int i = 0; i < types.length; ++i) {
                if (types[i].trim().length() == 0) {
                    params[i] = null;
                    continue;
                }
                if (types[i].equals(String.class.getName())) {
                    paramObjects[i] = params[i];
                    continue;
                }
                if (types[i].equals(File.class.getName())) {
                    paramObjects[i] = new File(params[i]);
                    continue;
                }
                if (types[i].equals(ArrayList.class.getName())) {
                    paramObjects[i] = SurefireBooter.processStringList(params[i]);
                    continue;
                }
                if (types[i].equals(Boolean.class.getName())) {
                    paramObjects[i] = Boolean.valueOf(params[i]);
                    continue;
                }
                if (types[i].equals(Integer.class.getName())) {
                    paramObjects[i] = Integer.valueOf(params[i]);
                    continue;
                }
                throw new IllegalArgumentException("Unknown parameter type: " + types[i]);
            }
        }
        return paramObjects;
    }

    private static List<String> processStringList(String stringList) {
        String sl = stringList;
        if (sl.startsWith("[") && sl.endsWith("]")) {
            sl = sl.substring(1, sl.length() - 1);
        }
        ArrayList<String> list = new ArrayList<String>();
        String[] stringArray = StringUtils.split((String)sl, (String)",");
        for (int i = 0; i < stringArray.length; ++i) {
            list.add(stringArray[i].trim());
        }
        return list;
    }

    private ClassLoader getParentClassLoader() throws Exception {
        ArrayList<URL> constituents = new ArrayList<URL>();
        for (String constituent : this.parentClasspath) {
            constituents.add(new URL(constituent));
        }
        URLClassLoader parentClassLoader = new URLClassLoader(this.toArray(constituents));
        System.getProperties().put("eoa.system.parent.classloader", parentClassLoader);
        return parentClassLoader;
    }

    private ClassLoader getSharedClassLoader(ClassLoader parent) throws Exception {
        ArrayList<URL> constituents = new ArrayList<URL>();
        for (String constituent : this.sharedClasspath) {
            constituents.add(new URL(constituent));
        }
        ClassLoader scl = null;
        try {
            String className = "org.bluestemsoftware.specification.eoa.SharedClassLoader";
            Class<?> clazz = parent.loadClass(className);
            Constructor<?> ctr = clazz.getConstructor(ClassLoader.class);
            scl = (ClassLoader)ctr.newInstance(parent);
            Class[] parameterTypes = new Class[]{URL.class};
            Method method = clazz.getDeclaredMethod("addURL", parameterTypes);
            for (URL url : this.toArray(constituents)) {
                method.invoke((Object)scl, url);
            }
        }
        catch (Exception ex) {
            if (ex.getMessage() == null) {
                throw new SurefireExecutionException("Error creating shared classloader.", (Throwable)ex);
            }
            throw new SurefireExecutionException("Error creating shared classloader. " + ex.getMessage(), (Throwable)ex);
        }
        scl.setDefaultAssertionStatus(true);
        System.getProperties().put("eoa.system.shared.classloader", scl);
        return scl;
    }

    private ClassLoader getDeploymentClassLoader(ClassLoader parent, ClassLoader scl) throws Exception {
        ArrayList<URL> constituents = new ArrayList<URL>();
        for (String constituent : this.deploymentClasspath) {
            constituents.add(new URL(constituent));
        }
        ClassLoader dcl = null;
        try {
            String className = "org.bluestemsoftware.specification.eoa.DeploymentClassLoader";
            Class<?> clazz = parent.loadClass(className);
            Constructor<?> ctr = clazz.getConstructor(String.class, URL[].class, ClassLoader.class, scl.getClass());
            String id = null;
            id = this.packaging.equals("eoa-component") ? this.groupID + "/" + this.artifactID + "/" + this.version + "/" + this.packaging : this.groupID + "/" + this.artifactID + "/" + this.packaging;
            dcl = (ClassLoader)ctr.newInstance(id, this.toArray(constituents), parent, scl);
        }
        catch (Exception ex) {
            if (ex.getMessage() == null) {
                throw new SurefireExecutionException("Error creating deployment classloader.", (Throwable)ex);
            }
            throw new SurefireExecutionException("Error creating deployment classloader. " + ex.getMessage(), (Throwable)ex);
        }
        dcl.setDefaultAssertionStatus(true);
        System.getProperties().put("eoa.system.deployment.classloader", dcl);
        return dcl;
    }

    private ClassLoader getClientClassLoader() throws Exception {
        ArrayList<URL> constituents = new ArrayList<URL>();
        for (String constituent : this.clientClasspath) {
            constituents.add(new URL(constituent));
        }
        return new URLClassLoader(this.toArray(constituents));
    }

    private ClassLoader getSurefireClassLoader(ClassLoader parent) throws Exception {
        ArrayList<URL> constituents = new ArrayList<URL>();
        for (String constituent : this.surefireClasspath) {
            constituents.add(new URL(constituent));
        }
        URLClassLoader surefireClassLoader = new URLClassLoader(this.toArray(constituents), parent);
        surefireClassLoader.setDefaultAssertionStatus(true);
        return surefireClassLoader;
    }

    private URL[] toArray(List<URL> constituents) {
        URL[] array = new URL[constituents.size()];
        Iterator<URL> itr = constituents.iterator();
        int i = 0;
        while (itr.hasNext()) {
            array[i] = itr.next();
            ++i;
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getConfiguration(ClassLoader cl) throws Exception {
        String pcp = null;
        pcp = this.isClientTest ? "META-INF/services/org.bluestemsoftware.open.eoa.test.client.cfg.ClientConfiguration" : "META-INF/services/org.bluestemsoftware.open.eoa.test.system.cfg.SystemConfiguration";
        Class<?> clazz = null;
        URL resource = cl.getResource(pcp);
        if (resource != null) {
            ArrayList<String> classNames = new ArrayList<String>();
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(resource.openStream(), "UTF-8"));
                String line = reader.readLine();
                while (line != null) {
                    if (line.indexOf(35) >= 0) {
                        line = line.substring(0, line.indexOf(35)).trim();
                    }
                    if (line.length() > 0) {
                        classNames.add(line);
                    }
                    line = reader.readLine();
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ignore) {}
                }
            }
            try {
                clazz = cl.loadClass((String)classNames.get(0));
            }
            catch (RuntimeException re) {
                throw new SurefireExecutionException("Error loading service provider implementation of " + pcp + ". ", (Throwable)re);
            }
        }
        if (clazz == null) {
            String sc = null;
            sc = this.isClientTest ? "org.bluestemsoftware.open.eoa.test.client.cfg.AbstractClientConfiguration" : "org.bluestemsoftware.open.eoa.test.system.cfg.AbstractSystemConfiguration";
            clazz = cl.loadClass(sc);
        }
        return clazz.newInstance();
    }

    private String getClientTestClassesDirectory() {
        if (!this.isIntegrationTest) {
            return null;
        }
        if (this.isClientTest) {
            return null;
        }
        File system = new File(this.testClassesDirectory).getParentFile();
        File suite = system.getParentFile();
        File client = new File(suite, "client/");
        if (!client.exists()) {
            return null;
        }
        return new File(client, "test-classes/").getAbsolutePath();
    }

    private File getClientTestReportsDirectory() {
        File suite = this.reportsDirectory.getParentFile();
        return new File(suite, "client/");
    }

    private String getClientWorkingDirectory() {
        File system = new File(this.workingDirectory);
        File suite = system.getParentFile();
        return new File(suite, "client/").getAbsolutePath();
    }

    private void addClientTestSuiteDefinitions(SurefireBooter surefireBooter) {
        ArrayList<String> includes = new ArrayList<String>(Arrays.asList("**/Test*.java", "**/*Test.java", "**/*TestCase.java"));
        ArrayList<String> excludes = new ArrayList<String>(Arrays.asList("**/Abstract*Test.java", "**/Abstract*TestCase.java", "**/*$*"));
        String className = "org.apache.maven.surefire.junit4.JUnit4DirectoryTestSuite";
        File clientTestClassesDirectory = new File(this.getClientTestClassesDirectory());
        Object[] parms = new Object[]{clientTestClassesDirectory, includes, excludes};
        surefireBooter.addTestSuite(className, parms);
    }

    private void addClientReportDefinitions(SurefireBooter surefireBooter) {
        for (Object[] report : this.reports) {
            Boolean trimStackTrace;
            String name = (String)report[0];
            Object[] parms = (Object[])report[1];
            if (name.equals(ConsoleReporter.class.getName())) {
                trimStackTrace = (Boolean)parms[0];
                surefireBooter.addReport(name, new Object[]{trimStackTrace});
                continue;
            }
            trimStackTrace = (Boolean)parms[1];
            File testReportsDirectory = this.getClientTestReportsDirectory();
            surefireBooter.addReport(name, new Object[]{testReportsDirectory, trimStackTrace});
        }
    }

    private String getDebugProperty() {
        if (System.getProperty("maven.surefire.debug") != null) {
            return "maven.surefire.debug";
        }
        if (System.getProperty("maven.surefire.it.debug") != null) {
            return "maven.surefire.it.debug";
        }
        if (System.getProperty("maven.surefire.it.client.debug") != null) {
            return "maven.surefire.it.client.debug";
        }
        return null;
    }
}

