/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jettison.mapped;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.codehaus.jettison.Convention;
import org.codehaus.jettison.Node;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.mapped.Configuration;
import org.codehaus.jettison.mapped.DefaultConverter;
import org.codehaus.jettison.mapped.TypeConverter;

public class MappedNamespaceConvention
implements Convention,
NamespaceContext {
    private Map xnsToJns = new HashMap();
    private Map jnsToXns = new HashMap();
    private List attributesAsElements;
    private List jsonAttributesAsElements;
    private boolean supressAtAttributes;
    private boolean ignoreNamespaces;
    private TypeConverter typeConverter;

    public MappedNamespaceConvention() {
        this.typeConverter = new DefaultConverter();
    }

    public MappedNamespaceConvention(Configuration config) {
        this.xnsToJns = config.getXmlToJsonNamespaces();
        this.attributesAsElements = config.getAttributesAsElements();
        this.supressAtAttributes = config.isSupressAtAttributes();
        this.ignoreNamespaces = config.isIgnoreNamespaces();
        for (Map.Entry entry : this.xnsToJns.entrySet()) {
            this.jnsToXns.put(entry.getValue(), entry.getKey());
        }
        this.jsonAttributesAsElements = new ArrayList();
        if (this.attributesAsElements != null) {
            for (QName q : this.attributesAsElements) {
                this.jsonAttributesAsElements.add(this.createAttributeKey(q.getPrefix(), q.getNamespaceURI(), q.getLocalPart()));
            }
        }
        this.typeConverter = config.getTypeConverter();
    }

    public void processAttributesAndNamespaces(Node n, JSONObject object) throws JSONException {
        Iterator itr = object.keys();
        while (itr.hasNext()) {
            JSONArray array;
            String k = (String)itr.next();
            if (this.supressAtAttributes) {
                if (k.startsWith("@")) {
                    k = k.substring(1);
                }
                if (null == this.jsonAttributesAsElements) {
                    this.jsonAttributesAsElements = new ArrayList();
                }
                if (!this.jsonAttributesAsElements.contains(k)) {
                    this.jsonAttributesAsElements.add(k);
                }
            }
            if (k.startsWith("@")) {
                String value = object.optString(k);
                k = k.substring(1);
                if (value != null) {
                    this.readAttribute(n, k, value);
                } else {
                    array = object.optJSONArray(k);
                    if (array != null) {
                        this.readAttribute(n, k, array);
                    }
                }
                itr.remove();
                continue;
            }
            if (this.jsonAttributesAsElements != null && this.jsonAttributesAsElements.contains(k)) {
                String value = object.optString(k);
                if (value != null) {
                    this.readAttribute(n, k, value);
                } else {
                    array = object.optJSONArray(k);
                    if (array != null) {
                        this.readAttribute(n, k, array);
                    }
                }
                itr.remove();
                continue;
            }
            int dot = k.lastIndexOf(46);
            if (dot == -1) continue;
            String jns = k.substring(0, dot);
            String xns = this.getNamespaceURI(jns);
            n.setNamespace("", xns);
        }
    }

    public String getNamespaceURI(String prefix) {
        if (this.ignoreNamespaces) {
            return "";
        }
        return (String)this.jnsToXns.get(prefix);
    }

    public String getPrefix(String namespaceURI) {
        if (this.ignoreNamespaces) {
            return "";
        }
        return (String)this.xnsToJns.get(namespaceURI);
    }

    public Iterator getPrefixes(String arg0) {
        if (this.ignoreNamespaces) {
            return Collections.EMPTY_SET.iterator();
        }
        return this.jnsToXns.keySet().iterator();
    }

    public QName createQName(String rootName, Node node) {
        return this.createQName(rootName);
    }

    private void readAttribute(Node n, String k, JSONArray array) throws JSONException {
        for (int i = 0; i < array.length(); ++i) {
            this.readAttribute(n, k, array.getString(i));
        }
    }

    private void readAttribute(Node n, String name, String value) throws JSONException {
        QName qname = this.createQName(name);
        n.getAttributes().put(qname, value);
    }

    private QName createQName(String name) {
        int dot = name.lastIndexOf(46);
        QName qname = null;
        String local = name;
        if (dot == -1) {
            dot = 0;
        } else {
            local = local.substring(dot + 1);
        }
        String jns = name.substring(0, dot);
        String xns = this.getNamespaceURI(jns);
        qname = xns == null ? new QName(name) : new QName(xns, local);
        return qname;
    }

    public String createAttributeKey(String p, String ns, String local) {
        String jns;
        StringBuffer builder = new StringBuffer();
        if (!this.supressAtAttributes) {
            builder.append('@');
        }
        if ((jns = this.getPrefix(ns)) != null && jns.length() != 0) {
            builder.append(jns).append('.');
        }
        return builder.append(local).toString();
    }

    public String createKey(String p, String ns, String local) {
        StringBuffer builder = new StringBuffer();
        String jns = this.getPrefix(ns);
        if (jns != null && jns.length() != 0) {
            builder.append(jns).append('.');
        }
        return builder.append(local).toString();
    }

    public boolean isElement(String p, String ns, String local) {
        if (this.attributesAsElements == null) {
            return false;
        }
        for (QName q : this.attributesAsElements) {
            if (!q.getNamespaceURI().equals(ns) || !q.getLocalPart().equals(local)) continue;
            return true;
        }
        return false;
    }

    public Object convertToJSONPrimitive(String text) {
        return this.typeConverter.convertToJSONPrimitive(text);
    }
}

