
package org.blufin.core.auth.client;
import org.blufin.core.auth.enums.AuthMethod;
import org.blufin.sdk.base.AbstractClientData;
import org.blufin.sdk.embedded.dto.app.EmbeddedUser;
import org.blufin.sdk.embedded.dto.common.EmbeddedAccount;
import org.blufin.sdk.embedded.dto.common.EmbeddedThirdPartyApplication;
import lombok.Getter;
@Getter
public final class ClientDataContainer<U extends EmbeddedUser, A extends EmbeddedAccount, O extends EmbeddedThirdPartyApplication> implements AbstractClientData<U, A, O> {
    public static final int SYSTEM_USER = 0;
    private final AuthMethod authMethod;
    private final String ipAddress;
    private final A account;
    private final U user;
    private final O thirdPartyApplication;
    public ClientDataContainer(String accountName) {
        this.authMethod = null;
        this.ipAddress = null;
        this.user = null;
        this.thirdPartyApplication = null;
        this.account = (A) new EmbeddedAccount();
        this.account.setAccountName(accountName);
    }
    public ClientDataContainer(AuthMethod authMethod, String ipAddress) {
        this.authMethod = authMethod;
        this.ipAddress = ipAddress;
        this.account = null;
        this.user = null;
        this.thirdPartyApplication = null;
    }
    public ClientDataContainer(AuthMethod authMethod, String ipAddress, A account) {
        this.authMethod = authMethod;
        this.ipAddress = ipAddress;
        this.account = account;
        this.user = null;
        this.thirdPartyApplication = null;
    }
    public ClientDataContainer(AuthMethod authMethod, String ipAddress, A account, U user) {
        this.authMethod = authMethod;
        this.ipAddress = ipAddress;
        this.account = account;
        this.user = user;
        this.thirdPartyApplication = null;
    }
    public ClientDataContainer(AuthMethod authMethod, String ipAddress, O thirdPartyApplication, A account) {
        this.authMethod = authMethod;
        this.ipAddress = ipAddress;
        this.account = account;
        this.user = null;
        this.thirdPartyApplication = thirdPartyApplication;
    }
    public ClientDataContainer(AuthMethod authMethod, String ipAddress, O thirdPartyApplication, A account, U user) {
        this.authMethod = authMethod;
        this.ipAddress = ipAddress;
        this.account = account;
        this.user = user;
        this.thirdPartyApplication = thirdPartyApplication;
    }
}
