
package org.blufin.core.auth.core;
import org.blufin.core.auth.enums.AuthMethod;
import lombok.Getter;
import java.util.Arrays;
import java.util.List;
public enum AuthInitializationLevel {
    INTERNAL(Arrays.asList(
            AuthMethod.NONE,
            AuthMethod.INTERNAL
    )),
    INTERNAL_ACCOUNT(Arrays.asList(
            AuthMethod.NONE,
            AuthMethod.INTERNAL,
            AuthMethod.INTERNAL_ACCOUNT,
            AuthMethod.CLIENT_ORIGINATING_ACCOUNT
    )),
    INTERNAL_ACCOUNT_USER(Arrays.asList(
            AuthMethod.NONE,
            AuthMethod.INTERNAL,
            AuthMethod.INTERNAL_ACCOUNT,
            AuthMethod.INTERNAL_ACCOUNT_USER,
            AuthMethod.CLIENT_ORIGINATING_ACCOUNT,
            AuthMethod.CLIENT_ORIGINATING_ACCOUNT_USER
    )),
    OAUTH_ACCOUNT(Arrays.asList(
            AuthMethod.NONE,
            AuthMethod.INTERNAL,
            AuthMethod.INTERNAL_ACCOUNT,
            AuthMethod.CLIENT_ORIGINATING_ACCOUNT,
            AuthMethod.OAUTH_ACCOUNT
    )),
    OAUTH_ACCOUNT_USER(Arrays.asList(
            AuthMethod.NONE,
            AuthMethod.INTERNAL,
            AuthMethod.INTERNAL_ACCOUNT,
            AuthMethod.INTERNAL_ACCOUNT_USER,
            AuthMethod.CLIENT_ORIGINATING_ACCOUNT,
            AuthMethod.CLIENT_ORIGINATING_ACCOUNT_USER,
            AuthMethod.OAUTH_ACCOUNT,
            AuthMethod.OAUTH_ACCOUNT_USER
    ));
    @Getter
    private final List<AuthMethod> authMethods;
    AuthInitializationLevel(List<AuthMethod> authMethods) {
        this.authMethods = authMethods;
    }
}
