
package org.blufin.core.auth.data;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.blufin.core.auth.annotations.OAuth;
import org.blufin.core.auth.annotations.Public;
import org.blufin.core.auth.annotations.Secured;
import org.blufin.core.auth.annotations.helper.BY;
import java.util.ArrayList;
import java.util.List;
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ControllerAnnotations {
    public static final String NO_ANNOTATIONS = "NONE";
    private boolean publiclyAccessible = false;
    private boolean secured = false;
    private boolean accountAware = false;
    private boolean userAware = false;
    private boolean oAuth = false;
    @Override
    public String toString() {
        List<String> annotations = new ArrayList<>();
        if (publiclyAccessible) {
            annotations.add(Public.class.getSimpleName());
        }
        if (secured) {
            annotations.add(Secured.class.getSimpleName());
        }
        if (accountAware) {
            annotations.add(BY.ACCOUNT.toString());
        }
        if (userAware) {
            annotations.add(BY.USER.toString());
        }
        if (oAuth) {
            annotations.add(OAuth.class.getSimpleName());
        }
        if (annotations.size() < 1) {
            annotations.add(NO_ANNOTATIONS);
        }
        return StringUtils.join(annotations, "-");
    }
}
