
package org.blufin.core.auth.data;
import lombok.Getter;
import org.blufin.sdk.enums.AuthHeader;
import java.util.Map;
@Getter
public class RequestHeaders {
    public static final String IP_HEADER = "X-Real-IP";
    private final String authInternal;
    private final String authAccountName;
    private final String authAccountUser;
    private final String authIdentifier;
    private final String authToken;
    private final String oAuthDev;
    private final String oAuthApp;
    private final String oAuthAccountUser;
    private final String oAuthAccountToken;
    private final String xRealIP;
    public RequestHeaders(Map<String, String> headers) {
        authInternal = headers.getOrDefault(AuthHeader.AUTH_INTERNAL.toString(), null);
        authAccountName = headers.getOrDefault(AuthHeader.AUTH_ACCOUNT_NAME.toString(), null);
        authAccountUser = headers.getOrDefault(AuthHeader.AUTH_ACCOUNT_USER.toString(), null);
        authIdentifier = headers.getOrDefault(AuthHeader.AUTH_IDENTIFIER.toString(), null);
        authToken = headers.getOrDefault(AuthHeader.AUTH_TOKEN.toString(), null);
        oAuthDev = headers.getOrDefault(AuthHeader.X_OAUTH_DEV.toString(), null);
        oAuthApp = headers.getOrDefault(AuthHeader.X_OAUTH_APP.toString(), null);
        oAuthAccountUser = headers.getOrDefault(AuthHeader.X_OAUTH_ACCOUNT_USER.toString(), null);
        oAuthAccountToken = headers.getOrDefault(AuthHeader.X_OAUTH_ACCOUNT_TOKEN.toString(), null);
        xRealIP = headers.getOrDefault(IP_HEADER, null);
    }
}
