
package org.blufin.core.auth.handlers;
import org.blufin.core.auth.client.ClientDataContainer;
import org.blufin.core.auth.data.RequestHeaders;
import org.blufin.core.auth.enums.AuthMethod;
import org.blufin.core.auth.exceptions.AuthenticationException;
import org.blufin.sdk.embedded.service.EmbeddedAccountService;
import java.text.MessageFormat;
public class ClientOriginatingAccountHandler extends AbstractAuthenticationHandler {
    public static final AuthMethod AUTH_METHOD = AuthMethod.CLIENT_ORIGINATING_ACCOUNT;
    public ClientOriginatingAccountHandler(String authorizationHeader, EmbeddedAccountService accountService) {
        setAuthorizationHeader(authorizationHeader);
        setAccountService(accountService);
    }
    @Override
    public ClientDataContainer authenticate(RequestHeaders headers) throws AuthenticationException {
        throw new AuthenticationException(MessageFormat.format("AuthMethod: {0} is not yet implemented!", AUTH_METHOD));
    }
}
