
package org.blufin.core.auth.handlers;
import org.blufin.core.auth.client.ClientDataContainer;
import org.blufin.core.auth.data.RequestHeaders;
import org.blufin.core.auth.enums.AuthMethod;
import org.blufin.core.auth.exceptions.AuthenticationException;
import org.blufin.sdk.embedded.dto.common.EmbeddedAccount;
import org.blufin.sdk.embedded.dto.common.EmbeddedThirdPartyApplication;
import org.blufin.sdk.embedded.service.EmbeddedAccountService;
import org.blufin.sdk.embedded.service.EmbeddedThirdPartyApplicationService;
import org.blufin.sdk.embedded.service.EmbeddedThirdPartyDeveloperService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
public class OAuthAccountHandler extends AbstractAuthenticationHandler {
    public static final AuthMethod AUTH_METHOD = AuthMethod.OAUTH_ACCOUNT;
    public OAuthAccountHandler(EmbeddedThirdPartyDeveloperService thirdPartyDeveloperService, EmbeddedThirdPartyApplicationService thirdPartyApplicationService, EmbeddedAccountService accountService) {
        setThirdPartyDeveloperService(thirdPartyDeveloperService);
        setThirdPartyApplicationService(thirdPartyApplicationService);
        setAccountService(accountService);
    }
    @Override
    public ClientDataContainer authenticate(RequestHeaders headers) throws AuthenticationException {
        if (headers.getOAuthDev() != null && headers.getOAuthApp() != null && headers.getOAuthAccountToken() != null) {
            ExecutorService executorService = Executors.newFixedThreadPool(2);
            try {
                Future<EmbeddedThirdPartyApplication> thirdPartyApplicationFuture = executorService.submit(() -> getThirdPartyApplication(headers.getOAuthDev(), headers.getOAuthApp()));
                Future<EmbeddedAccount> accountFuture = executorService.submit(() -> getAccount(headers.getOAuthAccountToken(), AUTH_METHOD));
                return new ClientDataContainer(AUTH_METHOD, headers.getXRealIP(), thirdPartyApplicationFuture.get(), accountFuture.get());
            } catch (InterruptedException | ExecutionException e) {
                throw new AuthenticationException(e.getMessage());
            } finally {
                executorService.shutdown();
            }
        }
        return null;
    }
}
