
package org.blufin.core.cloud.queue;
import org.blufin.base.utils.UtilsEnvironment;
import org.blufin.base.utils.UtilsLogger;
import org.blufin.core.cloud.AwsSQSClient;
import java.util.concurrent.atomic.AtomicBoolean;
public class MessageClient implements MessageClientInterface {
    private static volatile MessageClient instance;
    private MessageClientInterface messageClient;
    private AtomicBoolean consumingStarted = new AtomicBoolean(false);
    private MessageClient() {
        try {
            if (UtilsEnvironment.isLocal() || UtilsEnvironment.isDevelopment()) {
                this.messageClient = new RabbitMQClient(MessageQueueConfig.getInstance());
            } else {
                this.messageClient = new AwsSQSClient(MessageQueueConfig.getInstance());
            }
        } catch (Exception e) {
            UtilsLogger.error("MessageClient failed to load.", e);
        }
    }
    public static final MessageClient getInstance() {
        if (instance == null) {
            instance = new MessageClient();
        }
        return instance;
    }
    public void consume(MessageDeliveryHandler messageDeliveryHandler) {
        if (consumingStarted.get() == true) {
            throw new RuntimeException("MessageQueueClient.consume() was called twice.");
        }
        consumingStarted.set(true);
        messageClient.consume(messageDeliveryHandler);
    }
    public void produce(MessageOutgoing message) throws Exception {
        getInstance().messageClient.produce(message);
    }
}
