
package org.blufin.core.cloud.queue;
import com.google.common.base.Charsets;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import org.blufin.base.annotations.TestNotRequired;
import org.blufin.base.utils.UtilsLogger;
import org.blufin.jackson.Jackson;
import org.apache.commons.lang3.StringUtils;
import java.util.ArrayList;
import java.util.List;
@TestNotRequired
public class RabbitMQClient implements MessageClientInterface {
    private final Channel channel;
    private final MessageQueueConfig config;
    public RabbitMQClient(MessageQueueConfig config) {
        Channel channel = null;
        try {
            ConnectionFactory factory = new ConnectionFactory();
            factory.setHost(config.getHost());
            channel = factory.newConnection().createChannel();
            channel.queueDeclare(config.getName(), false, false, false, null);
        } catch (Exception e) {
            UtilsLogger.error("Failed to initialize a RabbitMQ connection.", e);
        } finally {
            this.config = config;
            this.channel = channel;
        }
    }
    @Override
    public void produce(MessageOutgoing message) throws Exception {
        channel.basicPublish("", config.getName(), null, Jackson.getObjectMapper().writeValueAsString(message).getBytes(Charsets.UTF_8));
    }
    @Override
    public void consume(MessageDeliveryHandler messageDeliveryHandler) {
        try {
            channel.basicConsume(config.getName(), false, new DefaultConsumer(channel) {
                @Override
                public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
                    String messageBody = StringUtils.EMPTY;
                    try {
                        List<MessageIncoming> messages = new ArrayList<>();
                        messageBody = new String(body, "UTF-8");
                        MessageOutgoing messageIncomingContent = Jackson.getObjectMapper().readValue(messageBody, MessageOutgoing.class);
                        MessageIncoming messageIncoming = new MessageIncoming(
                                messageIncomingContent.getType(),
                                messageIncomingContent.getBody(),
                                messageIncomingContent.getIp(),
                                properties.getMessageId(),
                                String.valueOf(envelope.getDeliveryTag())
                        );
                        messages.add(messageIncoming);
                        messageDeliveryHandler.handleDelivery(messages);
                    } catch (Exception e) {
                        UtilsLogger.alertDeveloper("Failed to convert a message from RabbitMQ to <MessageIncoming> type.", messageBody, e);
                    }
                }
            });
        } catch (Exception e) {
            UtilsLogger.error("Failed to consume message(s) from RabbitMQ.", e);
        }
    }
}
