
package org.blufin.core.cloud.storage;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.google.common.io.Files;
import org.blufin.base.utils.UtilsLogger;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.UUID;
public class AwsS3Client {
    public static final String TMP_FILE_DIRECTORY = "/tmp";
    public static final String TMP_FILE_EXTENSION = "txt";
    private final AmazonS3Client amazonS3Client;
    private final String bucket;
    public AwsS3Client(AmazonS3Client amazonS3Client, String bucket) {
        this.bucket = bucket;
        this.amazonS3Client = amazonS3Client;
    }
    public String uploadStringToS3(String data) {
        return uploadFileToS3(getFileFromString(data));
    }
    public String uploadFileToS3(File file) {
        String uuid = getUUID();
        try {
            amazonS3Client.putObject(new PutObjectRequest(this.bucket, uuid, file));
            if (!file.delete()) {
                UtilsLogger.error("Upload to Amazon S3 succeeded but file '" + file.getName() + "' failed to delete.");
            }
            return uuid;
        } catch (Exception e) {
            UtilsLogger.error("Uploading file '" + file.getName() + "' to Amazon S3 failed.", e);
        }
        return null;
    }
    private String getUUID() {
        return String.valueOf(UUID.randomUUID());
    }
    private File getFileFromString(String data) {
        String tmpFileName = TMP_FILE_DIRECTORY + "/" + getUUID() + "" + TMP_FILE_EXTENSION;
        try {
            Files.write(data, new File(tmpFileName), Charset.forName("UTF-8"));
            return new File(tmpFileName);
        } catch (IOException e) {
            UtilsLogger.error("File upload failed for: " + tmpFileName, e);
        }
        return null;
    }
}
