
package org.blufin.core.http;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import org.blufin.base.utils.UtilsLogger;
import java.io.IOException;
import java.text.MessageFormat;
public class HttpClient {
    public static HttpClientResponse get(String url) {
        try {
            HttpResponse<String> jsonResponse = Unirest.get(url).asString();
            return new HttpClientResponse(
                    jsonResponse.getStatus(),
                    jsonResponse.getStatusText(),
                    jsonResponse.getBody()
            );
        } catch (Exception e) {
            UtilsLogger.error(MessageFormat.format("HTTP GET to ''{0}'' failed.", url), e);
        }
        return null;
    }
    public static HttpClientResponse postJsonString(String url, String jsonString) {
        try {
            HttpResponse<String> jsonResponse = Unirest.post(url).header("accept", "application/json").body(jsonString).asString();
            return new HttpClientResponse(
                    jsonResponse.getStatus(),
                    jsonResponse.getStatusText(),
                    jsonResponse.getBody()
            );
        } catch (Exception e) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                Object json = mapper.readValue(jsonString, Object.class);
                UtilsLogger.error(MessageFormat.format("HTTP POST to ''{0}'' failed.", url), mapper.writerWithDefaultPrettyPrinter().writeValueAsString(json), e);
            } catch (IOException e1) {
                UtilsLogger.error("HTTP POST to '" + url + "' failed -- as did the JSON prettifying.", jsonString, e);
            }
        }
        return null;
    }
}
