
package org.blufin.core.security;
import org.blufin.base.utils.UtilsLogger;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.Base64;
public class Base64Encoder {
    public static String encode(String value) {
        return Base64.getEncoder().encodeToString(value.getBytes(StandardCharsets.UTF_8));
    }
    public static String decode(String value) {
        return new String(Base64.getDecoder().decode(value), StandardCharsets.UTF_8);
    }
    public static String getMD5Hash(String value) {
        String md5Hash = StringUtils.EMPTY;
        try {
            final MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(value.getBytes(StandardCharsets.UTF_8));
            final byte[] resultByte = messageDigest.digest();
            md5Hash = new String(Hex.encodeHex(resultByte));
        } catch (NoSuchAlgorithmException e) {
            UtilsLogger.error(MessageFormat.format("Failed to convert String to MD5 Hash: ", value), e);
        } finally {
            return md5Hash;
        }
    }
}
