
package org.blufin.core.security;
import org.blufin.base.interfaces.Initializable;
import org.blufin.base.helper.Pair;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;
public class Encryptor extends Initializable<Pair<String, String>> {
    public static final Encryptor instance = new Encryptor();
    private IvParameterSpec ivParameterSpec;
    private SecretKeySpec secretKeySpec;
    private Encryptor() {}
    @Deprecated
    public static Encryptor createDuplicateSingleton(Pair<String, String> configuration) {
        Encryptor encryptor = new Encryptor();
        encryptor.initializeClass(configuration);
        return encryptor;
    }
    public static void initialize(Pair<String, String> configuration) {
        instance.initializeClass(configuration);
        decryptWithoutException("USED-FOR-INITIALIZATION");
    }
    public static void shutdown() {
        instance.shutdownClass();
    }
    public static String encrypt(String stringToEncrypt) throws Exception {
        return instance.encryptDynamicallyBound(stringToEncrypt);
    }
    public static String decrypt(String stringToDecrypt) throws Exception {
        return instance.decryptDynamicallyBound(stringToDecrypt);
    }
    public String encryptDynamicallyBound(String stringToEncrypt) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        cipher.init(Cipher.ENCRYPT_MODE, getSecretKeySpec(), getIvParameterSpec());
        byte[] encrypted = cipher.doFinal(stringToEncrypt.getBytes(StandardCharsets.UTF_8));
        return Base64.encodeBase64String(encrypted);
    }
    public String decryptDynamicallyBound(String encryptedString) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        cipher.init(Cipher.DECRYPT_MODE, getSecretKeySpec(), getIvParameterSpec());
        byte[] original = cipher.doFinal(Base64.decodeBase64(encryptedString));
        return new String(original, StandardCharsets.UTF_8);
    }
    public static String encryptWithoutException(String stringToEncrypt) {
        try {
            return instance.encryptDynamicallyBound(stringToEncrypt);
        } catch (Exception e) {
            return StringUtils.EMPTY;
        }
    }
    public static String decryptWithoutException(String encryptedString) {
        try {
            return instance.decryptDynamicallyBound(encryptedString);
        } catch (Exception e) {
            return StringUtils.EMPTY;
        }
    }
    private IvParameterSpec getIvParameterSpec() {
        if (ivParameterSpec == null) {
            ivParameterSpec = new IvParameterSpec(getInitializationData().getValue().getBytes(StandardCharsets.UTF_8));
        }
        return ivParameterSpec;
    }
    private SecretKeySpec getSecretKeySpec() {
        if (secretKeySpec == null) {
            secretKeySpec = new SecretKeySpec(getInitializationData().getKey().getBytes(StandardCharsets.UTF_8), "AES");
        }
        return secretKeySpec;
    }
}
