
package org.blufin.core.security;
import org.blufin.core.security.bcrypt.BCrypt;
public class Hasher {
    private static int workload = 12;
    public static String hashPassword(String passwordPlaintext) {
        return BCrypt.hashPassword(passwordPlaintext, BCrypt.genSalt(workload));
    }
    public static boolean passwordMatches(String passwordPlaintext, String passwordHash) {
        if (null == passwordHash || !passwordHash.startsWith(BCrypt.HASH_PREFIX)) {
            return false;
        }
        return BCrypt.checkPassword(passwordPlaintext, passwordHash);
    }
}
