
package org.blufin.core.server.aws;
import com.amazonaws.util.EC2MetadataUtils;
import org.blufin.base.annotations.Singleton;
import org.blufin.base.enums.Environment;
import org.blufin.base.interfaces.Initializable;
import org.blufin.base.utils.UtilsLogger;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
public class AWSInstanceDataResolver extends Initializable<Environment> {
    private static AWSInstanceDataResolver instance = new AWSInstanceDataResolver();
    private AWSInstanceData awsInstanceData = new AWSInstanceData();
    private Environment environment;
    private boolean startupLoggingComplete = false;
    @Singleton
    public AWSInstanceDataResolver() {}
    public static void initialize(Environment environment) {
        instance.initializeClass(environment);
        instance.resolve();
    }
    public static AWSInstanceData getInstanceData() {
        return instance.awsInstanceData;
    }
    public static void resolve() {
        if (instance.getEnvironment().equals(Environment.PRODUCTION) || instance.getEnvironment().equals(Environment.STAGING)) {
            if (!instance.startupLoggingComplete) {
                throw new RuntimeException();
            }
            Map<String, String> metaData = new HashMap<>();
            List<String> metaDataKeys = Arrays.asList(
                    "ami-id",
                    "ami-launch-index",
                    "ami-manifest-path",
                    "hostname",
                    "instance-action",
                    "instance-id",
                    "instance-type",
                    "local-hostname",
                    "local-ipv4",
                    "mac",
                    "profile",
                    "public-hostname",
                    "public-ipv4",
                    "reservation-id",
                    "security-groups"
            );
            for (String metaDataKey : metaDataKeys) {
                metaData.put(metaDataKey, EC2MetadataUtils.getData("/latest/meta-data/" + metaDataKey));
                if (instance.startupLoggingComplete == false) {
                    UtilsLogger.logPurple(metaDataKey + ": " + UtilsLogger.ANSI_YELLOW + metaData.get(metaDataKey));
                }
            }
            instance.awsInstanceData = new AWSInstanceData(
                    metaData.get("ami-id"),
                    metaData.get("ami-launch-index"),
                    metaData.get("ami-manifest-path"),
                    metaData.get("hostname"),
                    metaData.get("instance-action"),
                    metaData.get("instance-id"),
                    metaData.get("instance-type"),
                    metaData.get("local-hostname"),
                    metaData.get("local-ipv4"),
                    metaData.get("mac"),
                    metaData.get("profile"),
                    metaData.get("public-hostname"),
                    metaData.get("public-ipv4"),
                    metaData.get("reservation-id"),
                    metaData.get("security-groups")
            );
        }
        instance.startupLoggingComplete = true;
    }
    private Environment getEnvironment() {
        if (environment == null) {
            environment = getInitializationData();
            if (!environment.equals(Environment.DEVELOPMENT) && !environment.equals(Environment.STAGING) && !environment.equals(Environment.PRODUCTION)) {
                throw new RuntimeException(MessageFormat.format("Invalid environment ''{0}''. Must be either: {1}, {2} or {3}", environment, Environment.DEVELOPMENT, Environment.STAGING, Environment.PRODUCTION));
            }
        }
        return environment;
    }
}
