
package org.blufin.core.server.config;
import lombok.Data;
import org.blufin.core.auth.core.AuthInitializationLevel;
import org.blufin.core.server.db.data.DataSourceConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.annotation.Validated;
import javax.validation.constraints.NotNull;
@Data
@Validated
@Configuration
@ConfigurationProperties(prefix = "blufin.api")
public class ApiConfig {
    private String authorizationHeader;
    private @NotNull AuthInitializationLevel authorizationLevel;
    private @NotNull String encryptionKey;
    private @NotNull String encryptionIv;
    private @NotNull DataSourceConfiguration configDatabase;
    private @NotNull DataSourceConfiguration commonDatabase;
}
