
package org.blufin.core.server.config;
import lombok.Data;
import org.blufin.base.enums.Environment;
import org.blufin.base.enums.ServerType;
import org.blufin.base.enums.TimeZone;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.annotation.Validated;
import javax.validation.constraints.NotNull;
@Data
@Validated
@Configuration
@ConfigurationProperties(prefix = "blufin.base")
public class BaseConfig {
    private @NotNull String profileName;
    private @NotNull String projectName;
    private @NotNull ServerType serverType;
    private @NotNull Environment environment;
    private @NotNull TimeZone timeZone;
    private @NotNull String messageQueueHost;
    private @NotNull String messageQueueName;
    private @NotNull String slackLogURL;
    private @NotNull String slackErrorsURL;
}
