
package org.blufin.core.server.db;
import lombok.Getter;
import org.blufin.base.annotations.Singleton;
import org.blufin.base.exceptions.BlufinServerException;
import org.blufin.core.server.db.base.AbstractDataSourceSingle;
import org.blufin.core.server.db.data.DataSourceConfiguration;
import org.springframework.stereotype.Service;
import java.sql.Connection;
@Service
public class ConfigDataSource extends AbstractDataSourceSingle {
    @Getter
    private static final ConfigDataSource instance = new ConfigDataSource();
    @Singleton
    private ConfigDataSource() {}
    public static void refresh(DataSourceConfiguration dataSourceConfiguration) {
        instance.refreshDataSources(dataSourceConfiguration);
    }
    public Connection getConnection() throws BlufinServerException {
        try {
            return instance.getDataConnection();
        } catch (Exception e) {
            throw new BlufinServerException("ConfigDataSource.getConnection() was unable to successfully retrieve a DB connection.");
        }
    }
}
