
package org.blufin.core.server.db;
import org.blufin.base.enums.SchemaType;
import org.blufin.base.exceptions.BlufinAlertDeveloperException;
import org.blufin.base.exceptions.BlufinServerException;
import org.blufin.core.auth.client.ClientDataFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.sql.Connection;
import java.text.MessageFormat;
@Service
public class ConnectionFactory {
    @Autowired
    AccountAwareDataSource accountAwareDataSource;
    @Autowired
    CommonDataSource commonDataSource;
    @Autowired
    ConfigDataSource configDataSource;
    public Connection getConnection(SchemaType schemaType) throws BlufinServerException {
        switch (schemaType) {
            case APP:
                return accountAwareDataSource.getConnection(ClientDataFactory.getClientData().getAccount().getAccountName());
            case COMMON:
                return commonDataSource.getConnection();
            case CONFIG:
                return configDataSource.getConnection();
            default:
                throw new BlufinAlertDeveloperException(MessageFormat.format("Unsupported schema: {0}", schemaType.name()));
        }
    }
}
