
package org.blufin.core.server.db.base;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import org.blufin.core.server.db.data.DataSourceConfiguration;
import org.blufin.core.utils.UtilsThread;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
public abstract class AbstractDataSource {
    private final static int REFRESH_TIMEOUT = 5;
    protected volatile boolean refreshInProgress = false;
    protected HikariDataSource build(DataSourceConfiguration dataSourceConfiguration) {
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : dataSourceConfiguration.getJdbcProperties().entrySet()) {
            properties.put(entry.getKey(), entry.getValue());
        }
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDriverClassName("com.mysql.cj.jdbc.Driver");
        hikariConfig.setJdbcUrl(dataSourceConfiguration.getJdbcUrl());
        hikariConfig.setUsername(dataSourceConfiguration.getUser());
        hikariConfig.setPassword(dataSourceConfiguration.getPassword());
        hikariConfig.setPoolName(dataSourceConfiguration.getPoolName());
        hikariConfig.setMaximumPoolSize(dataSourceConfiguration.getPoolMaxSize());
        hikariConfig.setDataSourceProperties(properties);
        hikariConfig.setRegisterMbeans(true);
        hikariConfig.setLeakDetectionThreshold(5000);
        String schema = dataSourceConfiguration.getSchema();
        if (schema != null && !schema.trim().equals("")) {
            hikariConfig.setCatalog(schema);
        }
        return new HikariDataSource(hikariConfig);
    }
    protected void waitWhileRefreshing() throws TimeoutException {
        int seconds = 0;
        while (refreshInProgress == true) {
            seconds++;
            if (seconds > REFRESH_TIMEOUT) {
                throw new TimeoutException(MessageFormat.format("Maximum timeout of {0} seconds exceeded.", REFRESH_TIMEOUT));
            }
            UtilsThread.sleep(1000);
        }
    }
}
