
package org.blufin.core.server.db.base;
import com.zaxxer.hikari.HikariDataSource;
import org.blufin.base.exceptions.BlufinAlertDeveloperException;
import org.blufin.core.server.db.data.DataSourceConfiguration;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.TimeoutException;
public class AbstractDataSourceSingle extends AbstractDataSource {
    private volatile HikariDataSource dataSource = null;
    private volatile String schema = null;
    protected void refreshDataSources(DataSourceConfiguration configuration) {
        if (dataSource != null) {
            dataSource.close();
        }
        schema = configuration.getSchema();
        if (schema == null || schema.trim().equals("")) {
            throw new BlufinAlertDeveloperException("When refreshing a SingleDataSource, schema cannot be null.");
        }
        dataSource = build(configuration);
    }
    protected Connection getDataConnection() throws SQLException, TimeoutException {
        if (dataSource == null) {
            throw new BlufinAlertDeveloperException("An implementation of a SingleDataSource was not properly initialized. Must call refresh() first.");
        }
        waitWhileRefreshing();
        Connection connection = dataSource.getConnection();
        connection.setCatalog(schema);
        connection.setAutoCommit(false);
        return connection;
    }
}
