
package org.blufin.core.server.helper;
import org.blufin.core.server.db.data.DataSourceConfiguration;
import org.blufin.sdk.embedded.base.EmbeddedSDK;
import org.blufin.sdk.embedded.dto.config.EmbeddedDb;
import org.blufin.sdk.embedded.dto.config.EmbeddedDbConfiguration;
import org.blufin.sdk.embedded.dto.config.EmbeddedDbConfigurationProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.HashMap;
@Service
public class DataSourceConfigurationTransformer {
    @Autowired
    EmbeddedSDK embeddedSDK;
    public DataSourceConfiguration transform(EmbeddedDb db) {
        DataSourceConfiguration dataSourceConfiguration = new DataSourceConfiguration();
        dataSourceConfiguration.setJdbcUrl(db.getJdbcUrl());
        dataSourceConfiguration.setUser(db.getUser());
        dataSourceConfiguration.setPassword(db.getPassword());
        dataSourceConfiguration.setPoolName(db.getDbName());
        EmbeddedDbConfiguration dbConfiguration = embeddedSDK.getEmbeddedDbConfigurationService()
                .get(1)
                .execute()
                .getBody()
                .get(0);
        dataSourceConfiguration.setPoolMaxSize(dbConfiguration.getPoolMaxSize());
        if (dbConfiguration.getDbConfigurationPropertyList().size() > 0) {
            HashMap<String, String> jdbcProperties = new HashMap<>();
            for (EmbeddedDbConfigurationProperty dbProperty : dbConfiguration.getDbConfigurationPropertyList()) {
                jdbcProperties.put(dbProperty.getKey(), dbProperty.getValue());
            }
            dataSourceConfiguration.setJdbcProperties(jdbcProperties);
        }
        return dataSourceConfiguration;
    }
}
