
package org.blufin.core.server.helper;
import org.blufin.base.exceptions.BlufinAlertDeveloperException;
import org.blufin.base.utils.UtilsNumber;
import org.blufin.base.utils.UtilsString;
import org.blufin.sdk.base.ResourceData;
import org.blufin.sdk.enums.HttpMethod;
import java.text.MessageFormat;
public final class EndPointHelper {
    public static final String LIST_SUFFIX = "/list";
    public static final String normalizeEndPoint(String endPoint, HttpMethod method) {
        endPoint = UtilsString.rtrim(UtilsString.ltrim(endPoint, "/"), "/");
        switch (method) {
            case POST:
            case PUT:
                endPoint = normalize(endPoint);
                break;
            case GET:
            case PATCH:
            case DELETE:
                break;
            default:
                throw new BlufinAlertDeveloperException(MessageFormat.format("Unhandled {0}: {1}", HttpMethod.class.getSimpleName(), method.toString()));
        }
        return endPoint;
    }
    private static String normalize(String endPoint) {
        endPoint = UtilsString.rtrim(endPoint, LIST_SUFFIX);
        StringBuilder sb = new StringBuilder();
        String[] endPointParts = endPoint.split("/");
        for (int i = 0; i < endPointParts.length; i++) {
            if (i == (endPointParts.length - 2)) {
                if (UtilsNumber.isInteger(endPointParts[i])) {
                    continue;
                }
            }
            sb.append(endPointParts[i]);
            if (i < endPointParts.length - 1) {
                sb.append("/");
            }
        }
        return sb.toString();
    }
}
