
package org.blufin.core.server.rest;
import org.blufin.base.exceptions.BlufinNotFoundException;
import org.blufin.sdk.response.HttpStatus;
import org.springframework.boot.autoconfigure.web.servlet.error.AbstractErrorController;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import javax.servlet.http.HttpServletRequest;
import java.text.MessageFormat;
import java.util.Map;
@Controller
public class ErrorController extends AbstractErrorController {
    public ErrorController(ErrorAttributes errorAttributes) {
        super(errorAttributes);
    }
    @Override
    public String getErrorPath() {
        return null;
    }
    @RequestMapping("${server.error.path:${error.path:/error}}")
    public ResponseEntity<Map<String, Object>> error(HttpServletRequest request) {
        String httpMethod = request.getMethod();
        String httpUri = request.getAttribute("javax.servlet.forward.request_uri").toString();
        String httpStatus = request.getAttribute("javax.servlet.error.status_code").toString();
        switch (HttpStatus.getFromCode(Integer.parseInt(httpStatus))) {
            case NOT_FOUND:
                throw new BlufinNotFoundException(
                        httpMethod,
                        httpUri,
                        httpStatus
                );
            default:
                throw new RuntimeException(MessageFormat.format("ErrorController encountered an error other than a 404 for: {0} {1}", httpMethod.toUpperCase(), httpUri));
        }
    }
}
