
package org.blufin.core.server.rest;
import javax.servlet.http.HttpServletRequest;
import java.util.Enumeration;
public class IpAddressResolver {
    public static final String IP_ADDRESS_BLANK = "0.0.0.0";
    public static final String IP_ADDRESS_REDIRECT_HEADER = "X-Real-IP";
    public static String get(HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String) headerNames.nextElement();
            if (key.toUpperCase().equals(IP_ADDRESS_REDIRECT_HEADER.toUpperCase())) {
                return request.getHeader(key);
            }
        }
        return IP_ADDRESS_BLANK;
    }
}
