
package org.blufin.core.server.rest;
import org.blufin.base.exceptions.BlufinAuthenticationException;
import org.blufin.base.exceptions.BlufinClientException;
import org.blufin.base.exceptions.BlufinForbiddenException;
import org.blufin.base.exceptions.BlufinNotFoundException;
import org.blufin.base.exceptions.BlufinNotImplementedException;
import org.blufin.sdk.response.ApiResponse;
import org.blufin.sdk.response.ApiResponseBuilder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;
@ControllerAdvice
public class RestExceptionHandler extends ResponseEntityExceptionHandler {
    @ResponseBody
    @ResponseStatus(HttpStatus.BAD_REQUEST)
    @ExceptionHandler(BlufinClientException.class)
    public ApiResponse badRequest(BlufinClientException e) {
        return ApiResponseBuilder.badRequest(e);
    }
    @ResponseBody
    @ResponseStatus(HttpStatus.UNAUTHORIZED)
    @ExceptionHandler(BlufinAuthenticationException.class)
    public ApiResponse unauthorized() {
        return ApiResponseBuilder.unauthorized();
    }
    @ResponseBody
    @ResponseStatus(HttpStatus.FORBIDDEN)
    @ExceptionHandler(BlufinForbiddenException.class)
    public ApiResponse forbidden() {
        return ApiResponseBuilder.forbidden();
    }
    @ResponseBody
    @ResponseStatus(HttpStatus.NOT_FOUND)
    @ExceptionHandler(BlufinNotFoundException.class)
    public ApiResponse notFound(BlufinNotFoundException e) {
        return ApiResponseBuilder.notFound(e);
    }
    @ResponseBody
    @ResponseStatus(HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(Throwable.class)
    public ApiResponse serverError(Throwable e) {
        return ApiResponseBuilder.serverError(e);
    }
    @ResponseBody
    @ResponseStatus(HttpStatus.NOT_IMPLEMENTED)
    @ExceptionHandler(BlufinNotImplementedException.class)
    public ApiResponse notImplemented(BlufinNotImplementedException e) {
        return ApiResponseBuilder.notImplemented(e);
    }
    @Override
    protected ResponseEntity<Object> handleExceptionInternal(Exception ex, @Nullable Object body, HttpHeaders headers, HttpStatus status, WebRequest request) {
        return new ResponseEntity<>(ApiResponseBuilder.genericError(ex, status), headers, status);
    }
}
