
package org.blufin.core.server.rest;
import org.blufin.base.constants.Constants;
import org.blufin.base.exceptions.BlufinServerException;
import org.blufin.core.auth.core.AuthCleaner;
import org.blufin.core.server.startup.ApiApplication;
import org.blufin.sdk.enums.HttpMethod;
import org.blufin.sdk.normalization.TerminologyNormalizer;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.text.MessageFormat;
public class RestInterceptor extends HandlerInterceptorAdapter {
    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        response.addHeader("X-Powered-By", "Blufin");
        HttpMethod httpMethod = HttpMethod.valueOf(request.getMethod());
        switch (httpMethod) {
            case POST:
            case PUT:
                TerminologyNormalizer.Type expectedType = getExpectedType((HandlerMethod) handler);
                if (expectedType != null) {
                    ((ModifiedRequest) request).validate(expectedType);
                }
                break;
            case GET:
            case PATCH:
            case DELETE:
                break;
            default:
                throw new BlufinServerException(MessageFormat.format("Unsupported {0}: {1}", HttpMethod.class.getSimpleName(), httpMethod));
        }
        return true;
    }
    private TerminologyNormalizer.Type getExpectedType(HandlerMethod handler) {
        HandlerMethod handlerMethod = handler;
        Method method = handlerMethod.getMethod();
        TerminologyNormalizer.Type expectedType = null;
        boolean requestBodyFound = false;
        for (int i = 0; i < method.getParameterAnnotations().length; i++) {
            for (Annotation annotation : method.getParameterAnnotations()[i]) {
                if (annotation.annotationType().getSimpleName().equals(RequestBody.class.getSimpleName())) {
                    if (requestBodyFound) {
                        throw new BlufinServerException(MessageFormat.format("@{0} annotation found twice in controller method {1} {2}", RequestBody.class.getSimpleName(), Constants.FORWARD_ARROW, Constants.PERIOD + method.getName() + "()"));
                    }
                    expectedType = TerminologyNormalizer.type(method.getParameterTypes()[i].getSimpleName().toLowerCase());
                    requestBodyFound = true;
                }
            }
        }
        return expectedType;
    }
    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
        return;
    }
    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) {
        AuthCleaner.clean();
    }
}
